/*
 * Decompiled with CFR 0.152.
 */
package aim4.im.v2i.batch;

import aim4.config.Debug;
import aim4.im.TrackModel;
import aim4.im.v2i.RequestHandler.BatchModeRequestHandler;
import aim4.im.v2i.batch.ReorderingStrategy;
import aim4.map.Road;
import aim4.msg.v2i.Request;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableSet;

public class RoadBasedReordering
implements ReorderingStrategy {
    public static final double DEFAULT_PROCESSING_INTERVAL = 2.0;
    private static final double COMP_COMM_DELAY = 0.05;
    private static final double LOOKAHEAD_TIME = 3.0;
    private static final double BATCH_INTERVAL = 2.0;
    private double nextProcessingTime;
    private double nextProposalDeadline;
    private double processingInterval = 2.0;

    public RoadBasedReordering(double processingInterval) {
        this.processingInterval = processingInterval;
    }

    @Override
    public void setInitialTime(double initTime) {
        this.nextProcessingTime = initTime + this.processingInterval;
        this.nextProposalDeadline = this.nextProcessingTime + 0.05;
    }

    @Override
    public List<BatchModeRequestHandler.IndexedProposal> getBatch(double currentTime, NavigableSet<BatchModeRequestHandler.IndexedProposal> queue, TrackModel trackModel) {
        List<BatchModeRequestHandler.IndexedProposal> proposals1 = this.selectProposals(currentTime, queue);
        List<BatchModeRequestHandler.IndexedProposal> proposals2 = this.reorderProposals(proposals1);
        this.nextProcessingTime = currentTime + this.processingInterval;
        this.nextProposalDeadline = this.nextProcessingTime + 0.05;
        return proposals2;
    }

    @Override
    public double getNextProcessingTime() {
        return this.nextProcessingTime;
    }

    @Override
    public double getNextProposalDeadline() {
        return this.nextProposalDeadline;
    }

    private List<BatchModeRequestHandler.IndexedProposal> selectProposals(double currentTime, NavigableSet<BatchModeRequestHandler.IndexedProposal> queue) {
        BatchModeRequestHandler.IndexedProposal iProposal;
        Request.Proposal proposal;
        double arrivalTime;
        LinkedList<BatchModeRequestHandler.IndexedProposal> result = new LinkedList<BatchModeRequestHandler.IndexedProposal>();
        double startTime = currentTime + 3.0;
        double endTime = startTime + 2.0;
        Iterator<BatchModeRequestHandler.IndexedProposal> iterator = queue.iterator();
        while (iterator.hasNext() && (arrivalTime = (proposal = (iProposal = iterator.next()).getProposal()).getArrivalTime()) < endTime) {
            result.add(iProposal);
        }
        return result;
    }

    private List<BatchModeRequestHandler.IndexedProposal> reorderProposals(List<BatchModeRequestHandler.IndexedProposal> iProposals) {
        HashMap partition = new HashMap();
        for (BatchModeRequestHandler.IndexedProposal iProposal : iProposals) {
            int laneId = iProposal.getProposal().getArrivalLaneID();
            Road road = Debug.currentMap.getRoad(laneId);
            if (partition.containsKey(road)) {
                ((List)partition.get(road)).add(iProposal);
                continue;
            }
            LinkedList<BatchModeRequestHandler.IndexedProposal> l = new LinkedList<BatchModeRequestHandler.IndexedProposal>();
            l.add(iProposal);
            partition.put(road, l);
        }
        LinkedList<BatchModeRequestHandler.IndexedProposal> result = new LinkedList<BatchModeRequestHandler.IndexedProposal>();
        for (List iProposals2 : partition.values()) {
            result.addAll(iProposals2);
        }
        return result;
    }
}

