/*
 * Decompiled with CFR 0.152.
 */
package aim4.im.v2i.policy;

import aim4.config.Debug;
import aim4.im.TrackModel;
import aim4.im.v2i.RequestHandler.RequestHandler;
import aim4.im.v2i.V2IManagerCallback;
import aim4.im.v2i.policy.ExtendedBasePolicyCallback;
import aim4.im.v2i.policy.Policy;
import aim4.im.v2i.reservation.AczManager;
import aim4.im.v2i.reservation.ReservationGrid;
import aim4.im.v2i.reservation.ReservationGridManager;
import aim4.msg.i2v.Confirm;
import aim4.msg.i2v.Reject;
import aim4.msg.v2i.Away;
import aim4.msg.v2i.Cancel;
import aim4.msg.v2i.Done;
import aim4.msg.v2i.Request;
import aim4.msg.v2i.V2IMessage;
import aim4.sim.StatCollector;
import aim4.util.HashMapRegistry;
import aim4.util.Registry;
import aim4.vehicle.VehicleUtil;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public final class BasePolicy
implements Policy,
ExtendedBasePolicyCallback {
    private static final double EARLY_ERROR = 0.01;
    private static final double LATE_ERROR = 0.01;
    protected V2IManagerCallback im;
    private RequestHandler requestHandler;
    private Registry<ReservationRecord> reservationRecordRegistry = new HashMapRegistry<ReservationRecord>();
    private Map<Integer, Integer> vinToReservationId = new HashMap<Integer, Integer>();
    private StatCollector<BasePolicy> statCollector;

    public static ProposalFilterResult standardProposalsFilter(List<Request.Proposal> proposals, double currentTime) {
        LinkedList<Request.Proposal> myProposals = new LinkedList<Request.Proposal>(proposals);
        BasePolicy.removeProposalWithLateArrivalTime(myProposals, currentTime);
        if (myProposals.isEmpty()) {
            return new ProposalFilterResult(Reject.Reason.ARRIVAL_TIME_TOO_LATE);
        }
        BasePolicy.removeProposalWithLargeArrivalTime(myProposals, currentTime + 10.0);
        if (myProposals.isEmpty()) {
            return new ProposalFilterResult(Reject.Reason.ARRIVAL_TIME_TOO_LARGE);
        }
        return new ProposalFilterResult(myProposals);
    }

    private static void removeProposalWithLateArrivalTime(List<Request.Proposal> proposals, double currentTime) {
        ListIterator<Request.Proposal> tpIter = proposals.listIterator();
        while (tpIter.hasNext()) {
            Request.Proposal prop = (Request.Proposal)tpIter.next();
            if (!(prop.getArrivalTime() <= currentTime)) continue;
            tpIter.remove();
        }
    }

    private static void removeProposalWithLargeArrivalTime(List<Request.Proposal> proposals, double futureTime) {
        ListIterator<Request.Proposal> tpIter = proposals.listIterator();
        while (tpIter.hasNext()) {
            Request.Proposal prop = (Request.Proposal)tpIter.next();
            if (!(prop.getArrivalTime() > futureTime)) continue;
            tpIter.remove();
        }
    }

    public BasePolicy(V2IManagerCallback im, RequestHandler requestHandler) {
        this(im, requestHandler, null);
    }

    public BasePolicy(V2IManagerCallback im, RequestHandler requestHandler, StatCollector<BasePolicy> statCollector) {
        this.im = im;
        this.statCollector = statCollector;
        this.setRequestHandler(requestHandler);
    }

    @Override
    public void setV2IManagerCallback(V2IManagerCallback im) {
        this.im = im;
    }

    public RequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    public void setRequestHandler(RequestHandler RequestHandler2) {
        this.requestHandler = RequestHandler2;
        this.requestHandler.setBasePolicyCallback(this);
    }

    @Override
    public void act(double timeStep) {
        this.requestHandler.act(timeStep);
        if (this.statCollector != null) {
            this.statCollector.collect(this);
        }
    }

    @Override
    public void sendComfirmMsg(int latestRequestId, ReserveParam reserveParam) {
        int vin = reserveParam.getVin();
        assert (!this.vinToReservationId.containsKey(vin));
        Integer gridTicket = this.im.getReservationGridManager().accept(reserveParam.getGridPlan());
        Integer aczTicket = reserveParam.getAczManager().accept(reserveParam.getAczPlan());
        assert (gridTicket == vin);
        assert (aczTicket == vin);
        int reservationId = this.reservationRecordRegistry.getNewId();
        Confirm confirmMsg = new Confirm(this.im.getId(), vin, reservationId, latestRequestId, reserveParam.getSuccessfulProposal().getArrivalTime(), 0.01, 0.01, reserveParam.getSuccessfulProposal().getArrivalVelocity(), reserveParam.getSuccessfulProposal().getArrivalLaneID(), reserveParam.getSuccessfulProposal().getDepartureLaneID(), this.im.getACZ(reserveParam.getSuccessfulProposal().getDepartureLaneID()).getMaxSize(), reserveParam.getGridPlan().getAccelerationProfile());
        this.im.sendI2VMessage(confirmMsg);
        ReservationRecord r = new ReservationRecord(vin, reserveParam.getSuccessfulProposal().getDepartureLaneID());
        this.reservationRecordRegistry.set(reservationId, r);
        this.vinToReservationId.put(vin, reservationId);
        if (Debug.isTargetVIN(vin)) {
            System.err.printf("workinglist = %s\n", reserveParam.getGridPlan().getWorkingList());
        }
    }

    @Override
    public void sendRejectMsg(int vin, int latestRequestId, Reject.Reason reason) {
        this.im.sendI2VMessage(new Reject(this.im.getId(), vin, latestRequestId, this.im.getCurrentTime(), reason));
    }

    @Override
    public ReserveParam findReserveParam(Request msg, List<Request.Proposal> proposals) {
        int vin = msg.getVin();
        Request.Proposal successfulProposal = null;
        ReservationGridManager.Plan gridPlan = null;
        AczManager aczManager = null;
        AczManager.Plan aczPlan = null;
        for (Request.Proposal proposal : proposals) {
            ReservationGridManager.Query gridQuery = new ReservationGridManager.Query(vin, proposal.getArrivalTime(), proposal.getArrivalVelocity(), proposal.getArrivalLaneID(), proposal.getDepartureLaneID(), msg.getSpec(), proposal.getMaximumTurnVelocity(), true);
            gridPlan = this.im.getReservationGridManager().query(gridQuery);
            if (gridPlan == null) continue;
            double stopDist = VehicleUtil.calcDistanceToStop(gridPlan.getExitVelocity(), msg.getSpec().getMaxDeceleration());
            aczManager = this.im.getAczManager(proposal.getDepartureLaneID());
            if (aczManager == null) {
                System.err.printf("FCFSPolicy::processRequestMsg(): aczManager should not be null.\n", new Object[0]);
                System.err.printf("proposal.getDepartureLaneID() = %d\n", proposal.getDepartureLaneID());
                aczPlan = null;
                continue;
            }
            AczManager.Query aczQuery = new AczManager.Query(vin, gridPlan.getExitTime(), gridPlan.getExitVelocity(), msg.getSpec().getLength(), stopDist);
            aczPlan = aczManager.query(aczQuery);
            if (aczPlan == null) continue;
            successfulProposal = proposal;
            break;
        }
        if (successfulProposal != null) {
            return new ReserveParam(vin, successfulProposal, gridPlan, aczManager, aczPlan);
        }
        return null;
    }

    @Override
    public double getCurrentTime() {
        return this.im.getCurrentTime();
    }

    @Override
    public ReservationGrid getReservationGrid() {
        return this.im.getReservationGrid();
    }

    @Override
    public boolean hasReservation(int vin) {
        return this.vinToReservationId.containsKey(vin);
    }

    @Override
    public void processV2IMessage(V2IMessage msg) {
        if (msg instanceof Request) {
            this.requestHandler.processRequestMsg((Request)msg);
        } else if (msg instanceof Cancel) {
            this.processCancelMsg((Cancel)msg);
        } else if (msg instanceof Done) {
            this.processDoneMsg((Done)msg);
        } else if (msg instanceof Away) {
            this.processAwayMsg((Away)msg);
        } else {
            throw new RuntimeException("Unhandled message type: " + msg);
        }
    }

    public void processCancelMsg(Cancel msg) {
        ReservationRecord r = this.reservationRecordRegistry.get(msg.getReservationID());
        if (r != null) {
            int vin = r.getVin();
            if (vin != msg.getVin()) {
                System.err.printf("BasePolicy::processCancelMsg(): The VIN of the message is different from the VIN on the record.\n", new Object[0]);
            }
            this.im.getReservationGridManager().cancel(vin);
            this.im.getAczManager(r.getAczLaneId()).cancel(vin);
            this.reservationRecordRegistry.setNull(msg.getReservationID());
            this.vinToReservationId.remove(vin);
        } else {
            System.err.printf("BasePolicy::processCancelMsg(): record not found\n", new Object[0]);
        }
    }

    public void processDoneMsg(Done msg) {
        ReservationRecord r = this.reservationRecordRegistry.get(msg.getReservationID());
        if (r != null) {
            int vin = r.getVin();
            if (vin != msg.getVin()) {
                System.err.printf("BasePolicy::processCancelMsg(): The VIN of the message is different from the VIN on the record.\n", new Object[0]);
            }
        } else {
            System.err.printf("BasePolicy::processDoneMsg(): record not found", new Object[0]);
        }
    }

    public void processAwayMsg(Away msg) {
        ReservationRecord r = this.reservationRecordRegistry.get(msg.getReservationID());
        if (r != null) {
            int vin = r.getVin();
            if (vin != msg.getVin()) {
                System.err.printf("BasePolicy::processCancelMsg(): The VIN of the message is different from the VIN on the record.\n", new Object[0]);
            }
            this.im.getACZ(r.getAczLaneId()).away(vin);
            this.reservationRecordRegistry.setNull(msg.getReservationID());
            this.vinToReservationId.remove(vin);
        } else {
            System.err.printf("BasePolicy::processAwayMsg(): record not found", new Object[0]);
        }
    }

    public StatCollector<BasePolicy> getStatCollector() {
        return this.statCollector;
    }

    @Override
    public TrackModel getTrackMode() {
        return this.im.getTrackModel();
    }

    public static class ProposalFilterResult {
        private List<Request.Proposal> proposals;
        private Reject.Reason reason;

        public ProposalFilterResult(List<Request.Proposal> proposals) {
            this.proposals = proposals;
            this.reason = null;
        }

        public ProposalFilterResult(Reject.Reason reason) {
            this.proposals = null;
            this.reason = reason;
        }

        public boolean isNoProposalLeft() {
            return this.proposals == null;
        }

        public List<Request.Proposal> getProposals() {
            return this.proposals;
        }

        public Reject.Reason getReason() {
            return this.reason;
        }
    }

    public static class ReserveParam {
        private int vin;
        private Request.Proposal successfulProposal;
        private ReservationGridManager.Plan gridPlan;
        private AczManager aczManager;
        private AczManager.Plan aczPlan;

        public ReserveParam(int vin, Request.Proposal successfulProposal, ReservationGridManager.Plan gridPlan, AczManager aczManager, AczManager.Plan aczPlan) {
            this.vin = vin;
            this.successfulProposal = successfulProposal;
            this.gridPlan = gridPlan;
            this.aczManager = aczManager;
            this.aczPlan = aczPlan;
        }

        public int getVin() {
            return this.vin;
        }

        public Request.Proposal getSuccessfulProposal() {
            return this.successfulProposal;
        }

        public ReservationGridManager.Plan getGridPlan() {
            return this.gridPlan;
        }

        public AczManager getAczManager() {
            return this.aczManager;
        }

        public AczManager.Plan getAczPlan() {
            return this.aczPlan;
        }
    }

    public static class ReservationRecord {
        private int vin;
        private int aczLaneId;

        public ReservationRecord(int vin, int aczLaneId) {
            this.vin = vin;
            this.aczLaneId = aczLaneId;
        }

        public int getVin() {
            return this.vin;
        }

        public int getAczLaneId() {
            return this.aczLaneId;
        }
    }
}

