/*
 * Decompiled with CFR 0.152.
 */
package aim4.im.v2i.policy;

import aim4.im.Intersection;
import aim4.im.TrackModel;
import aim4.im.v2i.V2IManager;
import aim4.im.v2i.V2IManagerCallback;
import aim4.im.v2i.policy.Policy;
import aim4.im.v2i.reservation.AczManager;
import aim4.im.v2i.reservation.AdmissionControlZone;
import aim4.im.v2i.reservation.ReservationGrid;
import aim4.im.v2i.reservation.ReservationGridManager;
import aim4.msg.i2v.Confirm;
import aim4.msg.i2v.I2VMessage;
import aim4.msg.i2v.Reject;
import aim4.msg.v2i.Request;
import aim4.msg.v2i.V2IMessage;
import aim4.sim.StatCollector;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class TimeoutPolicy
implements Policy,
V2IManagerCallback {
    private static final double DEFAULT_TIMEOUT_LENGTH = 1.0;
    private V2IManagerCallback im;
    private Policy policy;
    private double timeoutLength = 1.0;
    private TimeoutPolicyType timeoutPolicyType = TimeoutPolicyType.MAINTAIN;
    private Map<Integer, Double> timeouts = new LinkedHashMap<Integer, Double>();

    public TimeoutPolicy(V2IManager im, Policy policy) {
        this.im = im;
        this.policy = policy;
        policy.setV2IManagerCallback(this);
    }

    @Override
    public void setV2IManagerCallback(V2IManagerCallback im) {
        this.im = im;
    }

    @Override
    public void sendI2VMessage(I2VMessage msg) {
        if (msg instanceof Confirm) {
            this.im.sendI2VMessage(msg);
        } else if (msg instanceof Reject) {
            Reject rejectMsg = (Reject)msg;
            double nextComm = this.im.getCurrentTime() + this.timeoutLength;
            this.timeouts.put(msg.getVin(), nextComm);
            this.im.sendI2VMessage(new Reject(rejectMsg.getImId(), rejectMsg.getVin(), rejectMsg.getRequestId(), nextComm, rejectMsg.getReason()));
        }
    }

    @Override
    public int getId() {
        return this.im.getId();
    }

    @Override
    public double getCurrentTime() {
        return this.im.getCurrentTime();
    }

    @Override
    public Intersection getIntersection() {
        return this.im.getIntersection();
    }

    @Override
    public ReservationGrid getReservationGrid() {
        return this.im.getReservationGrid();
    }

    @Override
    public ReservationGridManager getReservationGridManager() {
        return this.im.getReservationGridManager();
    }

    @Override
    public AdmissionControlZone getACZ(int laneId) {
        return this.im.getACZ(laneId);
    }

    @Override
    public AczManager getAczManager(int laneId) {
        return this.im.getAczManager(laneId);
    }

    @Override
    public void act(double timeStep) {
        this.policy.act(timeStep);
        Iterator<Double> iter = this.timeouts.values().iterator();
        while (iter.hasNext()) {
            if (!(iter.next() <= this.im.getCurrentTime())) continue;
            iter.remove();
        }
    }

    @Override
    public void processV2IMessage(V2IMessage msg) {
        if (msg instanceof Request) {
            if (this.timeouts.containsKey(msg.getVin())) {
                double nextComm = this.calcTimeOut(msg.getVin());
                this.timeouts.put(msg.getVin(), nextComm);
                this.sendI2VMessage(new Reject(this.im.getId(), msg.getVin(), ((Request)msg).getRequestId(), nextComm, Reject.Reason.BEFORE_NEXT_ALLOWED_COMM));
            } else {
                this.policy.processV2IMessage(msg);
            }
        } else {
            this.policy.processV2IMessage(msg);
        }
    }

    private double calcTimeOut(int vin) {
        double nextComm = this.timeouts.get(vin);
        switch (this.timeoutPolicyType) {
            case MAINTAIN: {
                return nextComm;
            }
            case RESET: {
                return this.im.getCurrentTime() + this.timeoutLength;
            }
            case COMPOUND: {
                return nextComm + this.timeoutLength;
            }
        }
        throw new RuntimeException("Unhandled timeout policy: " + (Object)((Object)this.timeoutPolicyType));
    }

    @Override
    public StatCollector<?> getStatCollector() {
        return this.policy.getStatCollector();
    }

    @Override
    public TrackModel getTrackModel() {
        return this.im.getTrackModel();
    }

    public static enum TimeoutPolicyType {
        MAINTAIN,
        COMPOUND,
        RESET;

    }
}

