/*
 * Decompiled with CFR 0.152.
 */
package aim4.im.v2i.reservation;

import aim4.im.v2i.reservation.AdmissionControlZone;
import aim4.im.v2i.reservation.ReservationManager;

public class AczManager
implements ReservationManager<Query, Plan, Integer> {
    private AdmissionControlZone acz;

    public AczManager(AdmissionControlZone acz) {
        this.acz = acz;
    }

    @Override
    public Plan query(Query q) {
        if (this.acz.isAdmissible(q.getVin(), q.getVehicleLength(), q.getStopDist())) {
            return new Plan(q.getVin(), q.getVehicleLength(), q.getStopDist());
        }
        return null;
    }

    @Override
    public Integer accept(Plan plan) {
        this.acz.admit(plan.getVin(), plan.getLength(), plan.getStopDist());
        return plan.getVin();
    }

    @Override
    public void cancel(Integer vin) {
        this.acz.cancel(vin);
    }

    public static class Plan {
        private int vin;
        private double length;
        private double stopDist;

        public Plan(int vin, double length, double stopDist) {
            this.vin = vin;
            this.length = length;
            this.stopDist = stopDist;
        }

        public int getVin() {
            return this.vin;
        }

        public double getLength() {
            return this.length;
        }

        public double getStopDist() {
            return this.stopDist;
        }
    }

    public static class Query {
        private int vin;
        private double arrivalTime;
        private double arrivalVelocity;
        private double vehicleLength;
        private double stopDist;

        public Query(int vin, double arrivalTime, double arrivalVelocity, double vehicleLength, double stopDist) {
            this.vin = vin;
            this.arrivalTime = arrivalTime;
            this.arrivalVelocity = arrivalVelocity;
            this.vehicleLength = vehicleLength;
            this.stopDist = stopDist;
        }

        public int getVin() {
            return this.vin;
        }

        public double getArrivalTime() {
            return this.arrivalTime;
        }

        public double getArrivalVelocity() {
            return this.arrivalVelocity;
        }

        public double getVehicleLength() {
            return this.vehicleLength;
        }

        public double getStopDist() {
            return this.stopDist;
        }
    }
}

