/*
 * Decompiled with CFR 0.152.
 */
package aim4.im.v2i.reservation;

import aim4.config.Debug;
import aim4.driver.CrashTestDummy;
import aim4.driver.Driver;
import aim4.im.Intersection;
import aim4.im.v2i.reservation.ReservationGrid;
import aim4.im.v2i.reservation.ReservationManager;
import aim4.map.lane.Lane;
import aim4.msg.v2i.Request;
import aim4.sim.StatCollector;
import aim4.util.TiledArea;
import aim4.vehicle.BasicAutoVehicle;
import aim4.vehicle.VehicleSpec;
import aim4.vehicle.VehicleUtil;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class ReservationGridManager
implements ReservationManager<Query, Plan, Integer> {
    public Config config;
    public double staticBufferSize;
    private boolean isEdgeTileTimeBufferEnabled;
    private int internalTileTimeBufferSteps;
    private int edgeTileTimeBufferSteps;
    private double currentTime;
    private Intersection intersection;
    private TiledArea tiledArea;
    private ReservationGrid reservationGrid;
    private StatCollector<ReservationGridManager> statCollector;

    public ReservationGridManager(Config config, Intersection intersection, TiledArea tiledArea, ReservationGrid reservationGrid) {
        this(0.0, config, intersection, tiledArea, reservationGrid);
    }

    public ReservationGridManager(double currentTime, Config config, Intersection intersection, TiledArea tiledArea, ReservationGrid reservationGrid) {
        this.currentTime = currentTime;
        this.config = config;
        this.staticBufferSize = config.getStaticBufferSize();
        this.isEdgeTileTimeBufferEnabled = config.getIsEdgeTileTimeBufferEnabled();
        this.internalTileTimeBufferSteps = (int)(config.getInternalTileTimeBufferSize() / config.getGridTimeStep());
        this.edgeTileTimeBufferSteps = (int)(config.getEdgeTileTimeBufferSize() / config.getGridTimeStep());
        this.intersection = intersection;
        this.tiledArea = tiledArea;
        this.reservationGrid = reservationGrid;
        this.statCollector = new VinHistoryStatCollector();
    }

    public void act(double timeStep) {
        this.reservationGrid.cleanUp(this.currentTime);
        if (this.statCollector != null) {
            this.statCollector.collect(this);
        }
        this.currentTime += timeStep;
    }

    public Config getConfig() {
        return this.config;
    }

    public TiledArea getTiledArea() {
        return this.tiledArea;
    }

    public StatCollector<ReservationGridManager> getStatCollector() {
        return this.statCollector;
    }

    @Override
    public Plan query(Query q) {
        CrashTestDummy dummy;
        Lane arrivalLane = Debug.currentMap.getLaneRegistry().get(q.getArrivalLaneId());
        Lane departureLane = Debug.currentMap.getLaneRegistry().get(q.getDepartureLaneId());
        BasicAutoVehicle testVehicle = this.createTestVehicle(q.getSpec(), q.getArrivalVelocity(), q.getMaxTurnVelocity(), arrivalLane);
        FindTileTimesBySimulationResult fResult = this.findTileTimesBySimulation(testVehicle, dummy = new CrashTestDummy(testVehicle, arrivalLane, departureLane), q.getArrivalTime(), q.isAccelerating());
        if (fResult != null) {
            List<ReservationGrid.TimeTile> workingList = fResult.getWorkingList();
            double exitTime = workingList.get(workingList.size() - 1).getTime();
            Queue<double[]> accelerationProfile = this.calcAccelerationProfile(q.getArrivalTime(), q.getArrivalVelocity(), q.getMaxTurnVelocity(), q.getSpec().getMaxAcceleration(), fResult.getExitTime(), q.isAccelerating());
            return new Plan(q.getVin(), exitTime, testVehicle.gaugeVelocity(), workingList, accelerationProfile);
        }
        return null;
    }

    @Override
    public Integer accept(Plan plan) {
        boolean b = this.reservationGrid.reserve(plan.getVin(), plan.getWorkingList());
        assert (b);
        return plan.getVin();
    }

    @Override
    public void cancel(Integer reservationId) {
        this.reservationGrid.cancel(reservationId);
    }

    private BasicAutoVehicle createTestVehicle(Request.VehicleSpecForRequestMsg spec, double arrivalVelocity, double maxVelocity, Lane arrivalLane) {
        VehicleSpec newSpec = new VehicleSpec("TestVehicle", spec.getMaxAcceleration(), spec.getMaxDeceleration(), maxVelocity, spec.getMinVelocity(), spec.getLength(), spec.getWidth(), spec.getFrontAxleDisplacement(), spec.getRearAxleDisplacement(), 0.0, 0.0, 0.0, spec.getMaxSteeringAngle(), spec.getMaxTurnPerSecond());
        BasicAutoVehicle testVehicle = new BasicAutoVehicle(newSpec, this.intersection.getEntryPoint(arrivalLane), this.intersection.getEntryHeading(arrivalLane), 0.0, arrivalVelocity, 0.0, 0.0, 0.0);
        return testVehicle;
    }

    private FindTileTimesBySimulationResult findTileTimesBySimulation(BasicAutoVehicle testVehicle, Driver dummy, double arrivalTime, boolean accelerating) {
        Area areaPlus = this.intersection.getAreaPlus();
        assert (areaPlus.contains(testVehicle.getPointAtMiddleFront(1.0E-10)));
        ArrayList<ReservationGrid.TimeTile> workingList = new ArrayList<ReservationGrid.TimeTile>();
        int currentIntTime = this.reservationGrid.calcDiscreteTime(arrivalTime);
        double currentDuration = this.reservationGrid.calcRemainingTime(arrivalTime);
        while (VehicleUtil.intersects(testVehicle, areaPlus)) {
            this.moveTestVehicle(testVehicle, dummy, currentDuration, accelerating);
            ++currentIntTime;
            List<TiledArea.Tile> occupied = this.tiledArea.findOccupiedTiles(testVehicle.getShape(this.staticBufferSize));
            for (TiledArea.Tile tile : occupied) {
                int buffer = this.isEdgeTileTimeBufferEnabled && tile.isEdgeTile() ? this.edgeTileTimeBufferSteps : this.internalTileTimeBufferSteps;
                int tileId = tile.getId();
                for (int t = currentIntTime - buffer; t <= currentIntTime + buffer; ++t) {
                    if (this.reservationGrid.isReserved(t, tileId)) {
                        return null;
                    }
                    ReservationGrid reservationGrid = this.reservationGrid;
                    reservationGrid.getClass();
                    workingList.add(reservationGrid.new ReservationGrid.TimeTile(t, tile.getId()));
                }
            }
            currentDuration = this.reservationGrid.getGridTimeStep();
        }
        return new FindTileTimesBySimulationResult(workingList, this.reservationGrid.calcTime(currentIntTime));
    }

    private void moveTestVehicle(BasicAutoVehicle testVehicle, Driver dummy, double duration, boolean accelerating) {
        dummy.act();
        if (accelerating) {
            testVehicle.setMaxAccelWithMaxTargetVelocity();
        } else {
            testVehicle.coast();
        }
        testVehicle.move(duration);
    }

    private Queue<double[]> calcAccelerationProfile(double arrivalTime, double arrivalVelocity, double maxVelocity, double maxAcceleration, double exitTime, boolean accelerating) {
        LinkedList<double[]> accelerationProfile = new LinkedList<double[]>();
        double traversalTime = exitTime - arrivalTime;
        if (traversalTime <= 0.0) {
            System.err.printf("traversalTime = %.10f\n", traversalTime);
        }
        assert (traversalTime > 0.0);
        if (accelerating && maxVelocity > arrivalVelocity) {
            double accelerationDuration = Math.min(traversalTime, (maxVelocity - arrivalVelocity) / maxAcceleration);
            assert (accelerationDuration > 0.0);
            accelerationProfile.add(new double[]{maxAcceleration, accelerationDuration});
            if (accelerationDuration < traversalTime) {
                accelerationProfile.add(new double[]{0.0, traversalTime - accelerationDuration});
            }
        } else {
            accelerationProfile.add(new double[]{0.0, traversalTime});
        }
        return accelerationProfile;
    }

    public List<? extends Shape> getDebugShapes() {
        ArrayList<Rectangle2D> reservedRects = new ArrayList<Rectangle2D>();
        for (int i : this.reservationGrid.getReservedTilesAtTime(this.currentTime)) {
            reservedRects.add(this.tiledArea.getTileById(i).getRectangle());
        }
        return reservedRects;
    }

    private static class FindTileTimesBySimulationResult {
        List<ReservationGrid.TimeTile> workingList;
        double exitTime;

        public FindTileTimesBySimulationResult(List<ReservationGrid.TimeTile> workingList, double exitTime) {
            this.workingList = workingList;
            this.exitTime = exitTime;
        }

        public List<ReservationGrid.TimeTile> getWorkingList() {
            return this.workingList;
        }

        public double getExitTime() {
            return this.exitTime;
        }
    }

    public static class VinHistoryStatCollector
    implements StatCollector<ReservationGridManager> {
        private List<Double> vinHistoryTime = new LinkedList<Double>();
        private Map<Double, Set<Integer>> vinHistory = new HashMap<Double, Set<Integer>>();

        @Override
        public void collect(ReservationGridManager manager) {
            Set<Integer> s = manager.reservationGrid.getVinOfReservedTilesAtTime(manager.currentTime);
            Set<Integer> lasts = null;
            if (this.vinHistoryTime.size() > 0) {
                lasts = this.vinHistory.get(this.vinHistoryTime.get(this.vinHistoryTime.size() - 1));
            }
            if (!s.equals(lasts)) {
                this.vinHistoryTime.add(manager.currentTime);
                this.vinHistory.put(manager.currentTime, s);
            }
        }

        @Override
        public void print(PrintStream outfile) {
            for (double time : this.vinHistoryTime) {
                Set<Integer> vins = this.vinHistory.get(time);
                outfile.printf("%.2f", time);
                for (int vin : vins) {
                    outfile.printf(",%d", vin);
                }
                outfile.println();
            }
        }
    }

    public static class Plan {
        private int vin;
        private double exitTime;
        private double exitVelocity;
        private List<ReservationGrid.TimeTile> workingList;
        private Queue<double[]> accelerationProfile;

        public Plan(int vin, double exitTime, double exitVelocity, List<ReservationGrid.TimeTile> workingList, Queue<double[]> accelerationProfile) {
            this.vin = vin;
            this.exitTime = exitTime;
            this.exitVelocity = exitVelocity;
            this.workingList = workingList;
            this.accelerationProfile = accelerationProfile;
        }

        public int getVin() {
            return this.vin;
        }

        public double getExitTime() {
            return this.exitTime;
        }

        public double getExitVelocity() {
            return this.exitVelocity;
        }

        public List<ReservationGrid.TimeTile> getWorkingList() {
            return this.workingList;
        }

        public Queue<double[]> getAccelerationProfile() {
            return this.accelerationProfile;
        }
    }

    public static class Query {
        private int vin;
        private double arrivalTime;
        private double arrivalVelocity;
        private int arrivalLineId;
        private int departureLaneId;
        private Request.VehicleSpecForRequestMsg spec;
        private double maxTurnVelocity;
        private boolean accelerating;

        public Query(int vin, double arrivalTime, double arrivalVelocity, int arrivalLineId, int departureLaneId, Request.VehicleSpecForRequestMsg spec, double maxTurnVelocity, boolean accelerating) {
            this.vin = vin;
            this.arrivalTime = arrivalTime;
            this.arrivalVelocity = arrivalVelocity;
            this.arrivalLineId = arrivalLineId;
            this.departureLaneId = departureLaneId;
            this.spec = spec;
            this.maxTurnVelocity = maxTurnVelocity;
            this.accelerating = accelerating;
        }

        public int getVin() {
            return this.vin;
        }

        public double getArrivalTime() {
            return this.arrivalTime;
        }

        public double getArrivalVelocity() {
            return this.arrivalVelocity;
        }

        public int getArrivalLaneId() {
            return this.arrivalLineId;
        }

        public int getDepartureLaneId() {
            return this.departureLaneId;
        }

        public Request.VehicleSpecForRequestMsg getSpec() {
            return this.spec;
        }

        public double getMaxTurnVelocity() {
            return this.maxTurnVelocity;
        }

        public boolean isAccelerating() {
            return this.accelerating;
        }
    }

    public static class Config {
        private double timeStep;
        private double gridTimeStep;
        private double staticBufferSize;
        private double internalTileTimeBufferSize;
        private double edgeTileTimeBufferSize;
        private boolean isEdgeTileTimeBufferEnabled;
        private double granularity;

        public Config(double timeStep, double gridTimeStep, double staticBufferSize, double internalTileTimeBufferSize, double edgeTileTimeBufferSize, boolean isEdgeTileTimeBufferEnabled, double granularity) {
            this.timeStep = timeStep;
            this.gridTimeStep = gridTimeStep;
            this.staticBufferSize = staticBufferSize;
            this.internalTileTimeBufferSize = internalTileTimeBufferSize;
            this.edgeTileTimeBufferSize = edgeTileTimeBufferSize;
            this.isEdgeTileTimeBufferEnabled = isEdgeTileTimeBufferEnabled;
            this.granularity = granularity;
        }

        public double getTimeStep() {
            return this.timeStep;
        }

        public double getGridTimeStep() {
            return this.gridTimeStep;
        }

        public double getStaticBufferSize() {
            return this.staticBufferSize;
        }

        public double getInternalTileTimeBufferSize() {
            return this.internalTileTimeBufferSize;
        }

        public double getEdgeTileTimeBufferSize() {
            return this.edgeTileTimeBufferSize;
        }

        public boolean getIsEdgeTileTimeBufferEnabled() {
            return this.isEdgeTileTimeBufferEnabled;
        }

        public double getGranularity() {
            return this.granularity;
        }
    }
}

