/*
 * Decompiled with CFR 0.152.
 */
package aim4.map;

import aim4.config.Debug;
import aim4.im.IntersectionManager;
import aim4.map.BasicMap;
import aim4.map.DataCollectionLine;
import aim4.map.Road;
import aim4.map.SpawnPoint;
import aim4.map.lane.Lane;
import aim4.map.lane.LineSegmentLane;
import aim4.util.ArrayListRegistry;
import aim4.util.GeomMath;
import aim4.util.Registry;
import aim4.vehicle.VinRegistry;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GridMap
implements BasicMap {
    private static final double NO_VEHICLE_ZONE_LENGTH = 28.0;
    private static final double DATA_COLLECTION_LINE_POSITION = 28.0;
    private int rows;
    private int columns;
    private Rectangle2D dimensions;
    private List<Road> roads;
    private List<Road> horizontalRoads = new ArrayList<Road>();
    private List<Road> verticalRoads = new ArrayList<Road>();
    private List<IntersectionManager> intersectionManagers;
    private IntersectionManager[][] intersectionManagerGrid;
    private double memoMaximumSpeedLimit = -1.0;
    private List<DataCollectionLine> dataCollectionLines;
    private List<SpawnPoint> spawnPoints;
    private List<SpawnPoint> horizontalSpawnPoints;
    private List<SpawnPoint> verticalSpawnPoints;
    private Registry<Lane> laneRegistry = new ArrayListRegistry<Lane>();
    private Registry<IntersectionManager> imRegistry = new ArrayListRegistry<IntersectionManager>();
    private Map<Lane, Road> laneToRoad = new HashMap<Lane, Road>();

    public GridMap(double initTime, int columns, int rows, double laneWidth, double speedLimit, int lanesPerRoad, double medianSize, double distanceBetween) {
        int laneId;
        int i;
        LineSegmentLane l;
        if (rows < 1 || columns < 1) {
            throw new IllegalArgumentException("Must have at least one column and row!");
        }
        this.columns = columns;
        this.rows = rows;
        double height = (double)rows * (medianSize + (double)(2 * lanesPerRoad) * laneWidth + distanceBetween) + distanceBetween;
        double width = (double)columns * (medianSize + (double)(2 * lanesPerRoad) * laneWidth + distanceBetween) + distanceBetween;
        this.dimensions = new Rectangle2D.Double(0.0, 0.0, width, height);
        this.dataCollectionLines = new ArrayList<DataCollectionLine>(2 * (columns + rows));
        for (int column = 0; column < columns; ++column) {
            double roadMiddleX = (double)column * (medianSize + (double)(2 * lanesPerRoad) * laneWidth + distanceBetween) + distanceBetween + (double)lanesPerRoad * laneWidth + medianSize / 2.0;
            Road right = new Road(GeomMath.ordinalize(column + 1) + " Avenue N", this);
            for (int i2 = 0; i2 < lanesPerRoad; ++i2) {
                double x = roadMiddleX + (double)i2 * laneWidth + (laneWidth + medianSize) / 2.0;
                l = new LineSegmentLane(x, height, x, 0.0, laneWidth, speedLimit);
                int laneId2 = this.laneRegistry.register(l);
                l.setId(laneId2);
                right.addTheRightMostLane(l);
                this.laneToRoad.put(l, right);
            }
            this.verticalRoads.add(right);
            this.dataCollectionLines.add(new DataCollectionLine("NorthBound" + column + "Entrance", this.dataCollectionLines.size(), new Point2D.Double(roadMiddleX, height - 28.0), new Point2D.Double(roadMiddleX + (double)lanesPerRoad * laneWidth + medianSize, height - 28.0), true));
            this.dataCollectionLines.add(new DataCollectionLine("NorthBound" + column + "Exit", this.dataCollectionLines.size(), new Point2D.Double(roadMiddleX, 28.0), new Point2D.Double(roadMiddleX + (double)lanesPerRoad * laneWidth + medianSize, 28.0), true));
            Road left = new Road(GeomMath.ordinalize(column + 1) + " Avenue S", this);
            for (i = 0; i < lanesPerRoad; ++i) {
                double x = roadMiddleX - (double)i * laneWidth - (laneWidth + medianSize) / 2.0;
                LineSegmentLane l2 = new LineSegmentLane(x, 0.0, x, height, laneWidth, speedLimit);
                laneId = this.laneRegistry.register(l2);
                l2.setId(laneId);
                left.addTheRightMostLane(l2);
                this.laneToRoad.put(l2, left);
            }
            this.verticalRoads.add(left);
            this.dataCollectionLines.add(new DataCollectionLine("SouthBound" + column + "Entrance", this.dataCollectionLines.size(), new Point2D.Double(roadMiddleX, 28.0), new Point2D.Double(roadMiddleX - (double)lanesPerRoad * laneWidth - medianSize, 28.0), true));
            this.dataCollectionLines.add(new DataCollectionLine("SouthBound" + column + "Exit", this.dataCollectionLines.size(), new Point2D.Double(roadMiddleX, height - 28.0), new Point2D.Double(roadMiddleX - (double)lanesPerRoad * laneWidth - medianSize, height - 28.0), true));
            right.setDual(left);
        }
        for (int row = 0; row < rows; ++row) {
            double roadMiddleY = (double)row * (medianSize + (double)(2 * lanesPerRoad) * laneWidth + distanceBetween) + distanceBetween + (double)lanesPerRoad * laneWidth + medianSize / 2.0;
            Road lower = new Road(GeomMath.ordinalize(row + 1) + " Street E", this);
            for (int i3 = 0; i3 < lanesPerRoad; ++i3) {
                double y = roadMiddleY + (double)i3 * laneWidth + (laneWidth + medianSize) / 2.0;
                l = new LineSegmentLane(0.0, y, width, y, laneWidth, speedLimit);
                int laneId3 = this.laneRegistry.register(l);
                l.setId(laneId3);
                lower.addTheRightMostLane(l);
                this.laneToRoad.put(l, lower);
            }
            this.horizontalRoads.add(lower);
            this.dataCollectionLines.add(new DataCollectionLine("EastBound" + row + "Entrance", this.dataCollectionLines.size(), new Point2D.Double(28.0, roadMiddleY), new Point2D.Double(28.0, roadMiddleY + (double)lanesPerRoad * laneWidth + medianSize), true));
            this.dataCollectionLines.add(new DataCollectionLine("EastBound" + row + "Exit", this.dataCollectionLines.size(), new Point2D.Double(width - 28.0, roadMiddleY), new Point2D.Double(width - 28.0, roadMiddleY + (double)lanesPerRoad * laneWidth + medianSize), true));
            Road upper = new Road(GeomMath.ordinalize(row + 1) + " Street W", this);
            for (i = 0; i < lanesPerRoad; ++i) {
                double y = roadMiddleY - (double)i * laneWidth - (laneWidth + medianSize) / 2.0;
                LineSegmentLane l3 = new LineSegmentLane(width, y, 0.0, y, laneWidth, speedLimit);
                laneId = this.laneRegistry.register(l3);
                l3.setId(laneId);
                upper.addTheRightMostLane(l3);
                this.laneToRoad.put(l3, upper);
            }
            this.horizontalRoads.add(upper);
            this.dataCollectionLines.add(new DataCollectionLine("WestBound" + row + "Entrance", this.dataCollectionLines.size(), new Point2D.Double(width - 28.0, roadMiddleY), new Point2D.Double(width - 28.0, roadMiddleY - (double)lanesPerRoad * laneWidth - medianSize), true));
            this.dataCollectionLines.add(new DataCollectionLine("WestBound" + row + "Exit", this.dataCollectionLines.size(), new Point2D.Double(28.0, roadMiddleY), new Point2D.Double(28.0, roadMiddleY - (double)lanesPerRoad * laneWidth - medianSize), true));
            lower.setDual(upper);
        }
        this.roads = new ArrayList<Road>(this.horizontalRoads);
        this.roads.addAll(this.verticalRoads);
        this.roads = Collections.unmodifiableList(this.roads);
        this.intersectionManagers = new ArrayList<IntersectionManager>(columns * rows);
        this.intersectionManagerGrid = new IntersectionManager[columns][rows];
        this.initializeSpawnPoints(initTime);
    }

    private void initializeSpawnPoints(double initTime) {
        this.spawnPoints = new ArrayList<SpawnPoint>(this.columns + this.rows);
        this.horizontalSpawnPoints = new ArrayList<SpawnPoint>(this.rows);
        this.verticalSpawnPoints = new ArrayList<SpawnPoint>(this.columns);
        for (Road road : this.horizontalRoads) {
            for (Lane lane : road.getLanes()) {
                this.horizontalSpawnPoints.add(this.makeSpawnPoint(initTime, lane));
            }
        }
        for (Road road : this.verticalRoads) {
            for (Lane lane : road.getLanes()) {
                this.verticalSpawnPoints.add(this.makeSpawnPoint(initTime, lane));
            }
        }
        this.spawnPoints.addAll(this.horizontalSpawnPoints);
        this.spawnPoints.addAll(this.verticalSpawnPoints);
        Debug.currentMap = this;
    }

    private SpawnPoint makeSpawnPoint(double initTime, Lane lane) {
        double startDistance = 0.0;
        double normalizedStartDistance = lane.normalizedDistance(startDistance);
        Point2D pos = lane.getPointAtNormalizedDistance(normalizedStartDistance);
        double heading = lane.getInitialHeading();
        double steeringAngle = 0.0;
        double acceleration = 0.0;
        double d = lane.normalizedDistance(startDistance + 28.0);
        Rectangle2D noVehicleZone = lane.getShape(normalizedStartDistance, d).getBounds2D();
        return new SpawnPoint(initTime, pos, heading, steeringAngle, acceleration, lane, noVehicleZone);
    }

    @Override
    public List<Road> getRoads() {
        return this.roads;
    }

    @Override
    public List<Road> getDestinationRoads() {
        return this.roads;
    }

    @Override
    public Rectangle2D getDimensions() {
        return this.dimensions;
    }

    @Override
    public double getMaximumSpeedLimit() {
        if (this.memoMaximumSpeedLimit < 0.0) {
            for (Road r : this.getRoads()) {
                for (Lane l : r.getLanes()) {
                    if (!(l.getSpeedLimit() > this.memoMaximumSpeedLimit)) continue;
                    this.memoMaximumSpeedLimit = l.getSpeedLimit();
                }
            }
        }
        return this.memoMaximumSpeedLimit;
    }

    @Override
    public List<IntersectionManager> getIntersectionManagers() {
        return Collections.unmodifiableList(this.intersectionManagers);
    }

    @Override
    public List<DataCollectionLine> getDataCollectionLines() {
        return this.dataCollectionLines;
    }

    @Override
    public List<SpawnPoint> getSpawnPoints() {
        return this.spawnPoints;
    }

    public List<SpawnPoint> getHorizontalSpawnPoints() {
        return this.horizontalSpawnPoints;
    }

    public List<SpawnPoint> getVerticalSpawnPoints() {
        return this.verticalSpawnPoints;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public List<Road> getRoads(int column, int row) {
        if (row >= this.rows || column >= this.columns || row < 0 || column < 0) {
            throw new ArrayIndexOutOfBoundsException("(" + column + "," + row + " are not valid indices. This GridLayout only has " + column + " columns and " + row + " rows.");
        }
        ArrayList<Road> answer = new ArrayList<Road>();
        answer.add(this.verticalRoads.get(2 * column));
        answer.add(this.verticalRoads.get(2 * column + 1));
        answer.add(this.horizontalRoads.get(2 * row));
        answer.add(this.horizontalRoads.get(2 * row + 1));
        return answer;
    }

    public List<Road> getHorizontalRoads() {
        return this.horizontalRoads;
    }

    public List<Road> getVerticalRoads() {
        return this.verticalRoads;
    }

    @Override
    public Registry<IntersectionManager> getImRegistry() {
        return this.imRegistry;
    }

    @Override
    public Registry<Lane> getLaneRegistry() {
        return this.laneRegistry;
    }

    @Override
    public Road getRoad(Lane lane) {
        return this.laneToRoad.get(lane);
    }

    @Override
    public Road getRoad(int laneID) {
        return this.laneToRoad.get(this.laneRegistry.get(laneID));
    }

    public IntersectionManager getManager(int column, int row) {
        return this.intersectionManagerGrid[column][row];
    }

    @Override
    public void setManager(int column, int row, IntersectionManager im) {
        if (this.intersectionManagerGrid[column][row] != null) {
            throw new RuntimeException("The intersection manager at (" + column + ", " + row + ") has already been set!");
        }
        this.intersectionManagerGrid[column][row] = im;
        this.intersectionManagers.add(im);
    }

    public void removeAllManagers() {
        for (int column = 0; column < this.columns; ++column) {
            for (int row = 0; row < this.rows; ++row) {
                this.intersectionManagerGrid[column][row] = null;
            }
        }
        this.intersectionManagers.clear();
    }

    @Override
    public void printDataCollectionLinesData(String outFileName) {
        PrintStream outfile = null;
        try {
            outfile = new PrintStream(outFileName);
        }
        catch (FileNotFoundException e) {
            System.err.printf("Cannot open file %s\n", outFileName);
            return;
        }
        outfile.printf("VIN,Time,DCLname,vType,startLaneId,destRoad\n", new Object[0]);
        for (DataCollectionLine line : this.dataCollectionLines) {
            for (int vin : line.getAllVIN()) {
                for (double time : line.getTimes(vin)) {
                    outfile.printf("%d,%.4f,%s,%s,%d,%s\n", vin, time, line.getName(), VinRegistry.getVehicleSpecFromVIN(vin).getName(), VinRegistry.getSpawnPointFromVIN(vin).getLane().getId(), VinRegistry.getDestRoadFromVIN(vin).getName());
                }
            }
        }
        outfile.close();
    }
}

