/*
 * Decompiled with CFR 0.152.
 */
package aim4.map;

import aim4.map.GridMap;
import aim4.map.Road;
import aim4.map.lane.Lane;
import aim4.util.Util;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TrafficVolume {
    private Map<Integer, Double> leftTurnVolumes = new HashMap<Integer, Double>();
    private Map<Integer, Double> throughVolumes = new HashMap<Integer, Double>();
    private Map<Integer, Double> rightTurnVolumes = new HashMap<Integer, Double>();
    private Map<Integer, Double> totalVolumes = new HashMap<Integer, Double>();
    private Map<Road, Road> leftTurnRoad;
    private Map<Road, Road> rightTurnRoad;

    /*
     * WARNING - void declaration
     */
    public TrafficVolume(GridMap map, List<String> strs) {
        void var8_11;
        HashMap<String, String> roadNameTranslation = new HashMap<String, String>();
        roadNameTranslation.put("NB", "1st Avenue N");
        roadNameTranslation.put("SB", "1st Avenue S");
        roadNameTranslation.put("EB", "1st Street E");
        roadNameTranslation.put("WB", "1st Street W");
        HashMap<String, Road> roadNameToRoadObj = new HashMap<String, Road>();
        for (String roadName : roadNameTranslation.keySet()) {
            for (Road road : map.getRoads()) {
                if (!road.getName().equals(roadNameTranslation.get(roadName))) continue;
                roadNameToRoadObj.put(roadName, road);
            }
        }
        this.leftTurnRoad = new HashMap<Road, Road>();
        this.rightTurnRoad = new HashMap<Road, Road>();
        this.leftTurnRoad.put((Road)roadNameToRoadObj.get("NB"), (Road)roadNameToRoadObj.get("WB"));
        this.rightTurnRoad.put((Road)roadNameToRoadObj.get("NB"), (Road)roadNameToRoadObj.get("EB"));
        this.leftTurnRoad.put((Road)roadNameToRoadObj.get("SB"), (Road)roadNameToRoadObj.get("EB"));
        this.rightTurnRoad.put((Road)roadNameToRoadObj.get("SB"), (Road)roadNameToRoadObj.get("WB"));
        this.leftTurnRoad.put((Road)roadNameToRoadObj.get("EB"), (Road)roadNameToRoadObj.get("NB"));
        this.rightTurnRoad.put((Road)roadNameToRoadObj.get("EB"), (Road)roadNameToRoadObj.get("SB"));
        this.leftTurnRoad.put((Road)roadNameToRoadObj.get("WB"), (Road)roadNameToRoadObj.get("SB"));
        this.rightTurnRoad.put((Road)roadNameToRoadObj.get("WB"), (Road)roadNameToRoadObj.get("NB"));
        HashMap roadToLeftmostLanes = new HashMap();
        HashMap roadToMiddleLanes = new HashMap();
        HashMap roadToRightmostLanes = new HashMap();
        for (String roadName : roadNameTranslation.keySet()) {
            for (Road road : map.getRoads()) {
                if (!road.getName().equals(roadNameTranslation.get(roadName))) continue;
                roadToLeftmostLanes.put(roadName, new LinkedList());
                roadToMiddleLanes.put(roadName, new LinkedList());
                roadToRightmostLanes.put(roadName, new LinkedList());
                for (Lane lane : road.getLanes()) {
                    if (!lane.hasLeftNeighbor()) {
                        ((List)roadToLeftmostLanes.get(roadName)).add(lane);
                        continue;
                    }
                    if (!lane.hasRightNeighbor()) {
                        ((List)roadToRightmostLanes.get(roadName)).add(lane);
                        continue;
                    }
                    ((List)roadToMiddleLanes.get(roadName)).add(lane);
                }
            }
        }
        boolean bl = true;
        while (var8_11 < strs.size()) {
            String[] tokens = strs.get((int)var8_11).split(",");
            if (tokens[1].equals("Left")) {
                for (Lane lane : (List)roadToLeftmostLanes.get(tokens[0])) {
                    this.leftTurnVolumes.put(lane.getId(), Double.parseDouble(tokens[2]) / 3600.0);
                }
                for (Lane lane : (List)roadToMiddleLanes.get(tokens[0])) {
                    this.leftTurnVolumes.put(lane.getId(), Double.parseDouble(tokens[3]) / 3600.0);
                }
                for (Lane lane : (List)roadToRightmostLanes.get(tokens[0])) {
                    this.leftTurnVolumes.put(lane.getId(), Double.parseDouble(tokens[4]) / 3600.0);
                }
            } else if (tokens[1].equals("Through")) {
                for (Lane lane : (List)roadToLeftmostLanes.get(tokens[0])) {
                    this.throughVolumes.put(lane.getId(), Double.parseDouble(tokens[2]) / 3600.0);
                }
                for (Lane lane : (List)roadToMiddleLanes.get(tokens[0])) {
                    this.throughVolumes.put(lane.getId(), Double.parseDouble(tokens[3]) / 3600.0);
                }
                for (Lane lane : (List)roadToRightmostLanes.get(tokens[0])) {
                    this.throughVolumes.put(lane.getId(), Double.parseDouble(tokens[4]) / 3600.0);
                }
            } else if (tokens[1].equals("Right")) {
                for (Lane lane : (List)roadToLeftmostLanes.get(tokens[0])) {
                    this.rightTurnVolumes.put(lane.getId(), Double.parseDouble(tokens[2]) / 3600.0);
                }
                for (Lane lane : (List)roadToMiddleLanes.get(tokens[0])) {
                    this.rightTurnVolumes.put(lane.getId(), Double.parseDouble(tokens[3]) / 3600.0);
                }
                for (Lane lane : (List)roadToRightmostLanes.get(tokens[0])) {
                    this.rightTurnVolumes.put(lane.getId(), Double.parseDouble(tokens[4]) / 3600.0);
                }
            } else {
                throw new RuntimeException("Invalid data file.\n");
            }
            ++var8_11;
        }
        for (Road road : map.getRoads()) {
            for (Lane lane : road.getLanes()) {
                int laneId = lane.getId();
                double v = this.leftTurnVolumes.get(laneId) + this.throughVolumes.get(laneId) + this.rightTurnVolumes.get(laneId);
                this.totalVolumes.put(laneId, v);
            }
        }
    }

    public static TrafficVolume makeFromFile(GridMap map, String csvFileName) {
        List<String> strs = null;
        try {
            strs = Util.readFileToStrArray(csvFileName);
        }
        catch (IOException e) {
            System.err.println("Error: " + e.getMessage());
        }
        if (strs != null) {
            return new TrafficVolume(map, strs);
        }
        return null;
    }

    public double getLeftTurnVolume(int laneId) {
        return this.leftTurnVolumes.get(laneId);
    }

    public double getThroughVolume(int laneId) {
        return this.throughVolumes.get(laneId);
    }

    public double getRightTurnVolume(int laneId) {
        return this.rightTurnVolumes.get(laneId);
    }

    public double getTotalVolume(int laneId) {
        return this.totalVolumes.get(laneId);
    }

    public Road getLeftTurnRoad(Road road) {
        return this.leftTurnRoad.get(road);
    }

    public Road getRightTurnRoad(Road road) {
        return this.rightTurnRoad.get(road);
    }

    public String toString() {
        return "leftTurnVolumes: " + this.leftTurnVolumes + ",\nthroughVolumes: " + this.throughVolumes + ",\nrightTurnVolumes" + this.rightTurnVolumes + ".\n";
    }
}

