/*
 * Decompiled with CFR 0.152.
 */
package aim4.map.lane;

import aim4.map.lane.Lane;
import aim4.map.lane.LaneIM;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public abstract class AbstractLane
implements Lane {
    private int id = -1;
    private double speedLimit;
    private Lane nextLane;
    private Lane prevLane;
    private Lane rightNeighbor;
    private Lane leftNeighbor;
    private LaneIM laneIM;

    public AbstractLane(double speedLimit) {
        this.speedLimit = speedLimit;
        this.laneIM = new LaneIM(this);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public double getSpeedLimit() {
        return this.speedLimit;
    }

    @Override
    public LaneIM getLaneIM() {
        return this.laneIM;
    }

    @Override
    public boolean hasNextLane() {
        return this.nextLane != null;
    }

    @Override
    public Lane getNextLane() {
        return this.nextLane;
    }

    @Override
    public void setNextLane(Lane nextLane) {
        this.nextLane = nextLane;
    }

    @Override
    public boolean hasPrevLane() {
        return this.prevLane != null;
    }

    @Override
    public Lane getPrevLane() {
        return this.prevLane;
    }

    @Override
    public void setPrevLane(Lane prevLane) {
        this.prevLane = prevLane;
    }

    @Override
    public boolean hasLeftNeighbor() {
        return this.leftNeighbor != null;
    }

    @Override
    public Lane getLeftNeighbor() {
        return this.leftNeighbor;
    }

    @Override
    public void setLeftNeighbor(Lane ln) {
        this.leftNeighbor = ln;
    }

    @Override
    public boolean hasRightNeighbor() {
        return this.rightNeighbor != null;
    }

    @Override
    public Lane getRightNeighbor() {
        return this.rightNeighbor;
    }

    @Override
    public void setRightNeighbor(Lane ln) {
        this.rightNeighbor = ln;
    }

    @Override
    public abstract double getLength();

    @Override
    public abstract Point2D getStartPoint();

    @Override
    public abstract Point2D getEndPoint();

    @Override
    public abstract Point2D getPointAtNormalizedDistance(double var1);

    @Override
    public abstract Point2D nearestPoint(Point2D var1);

    @Override
    public abstract double nearestDistance(Point2D var1);

    @Override
    public abstract Point2D getLeadPoint(Point2D var1, double var2);

    @Override
    public abstract double distanceAlongLane(Point2D var1);

    @Override
    public abstract double remainingDistanceAlongLane(Point2D var1);

    @Override
    public abstract double normalizedDistanceAlongLane(Point2D var1);

    @Override
    public abstract double getInitialHeading();

    @Override
    public abstract double getTerminalHeading();

    @Override
    public abstract double getHeadingAtNormalizedDistance(double var1);

    @Override
    public abstract Point2D intersectionPoint(Line2D var1);

    @Override
    public abstract double getWidth();

    @Override
    public abstract Shape getShape();

    @Override
    public abstract Shape getShape(double var1, double var3);

    @Override
    public abstract boolean contains(Point2D var1);

    @Override
    public abstract Shape leftBorder();

    @Override
    public abstract Shape rightBorder();

    @Override
    public abstract Point2D leftIntersectionPoint(Line2D var1);

    @Override
    public abstract Point2D rightIntersectionPoint(Line2D var1);
}

