/*
 * Decompiled with CFR 0.152.
 */
package aim4.map.track;

import aim4.config.Constants;
import aim4.map.track.Track;
import aim4.map.track.TrackPosition;
import aim4.map.track.WayPoint;
import java.awt.Shape;
import java.awt.geom.Line2D;

public class LineTrack
implements Track {
    private WayPoint p1;
    private WayPoint p2;
    private double length;
    private double xLen;
    private double yLen;
    private double slope;
    private Line2D.Double line;

    public LineTrack(WayPoint p1, WayPoint p2) {
        this.p1 = p1;
        this.p2 = p2;
        this.line = new Line2D.Double(p1, p2);
        this.xLen = p2.getX() - p1.getX();
        this.yLen = p2.getY() - p1.getY();
        this.length = Math.sqrt(this.xLen * this.xLen + this.yLen * this.yLen);
        this.slope = Math.atan2(this.yLen, this.xLen);
    }

    @Override
    public WayPoint getStartWayPoint() {
        return this.p1;
    }

    @Override
    public WayPoint getEndWayPoint() {
        return this.p2;
    }

    @Override
    public double getLength() {
        return this.length;
    }

    @Override
    public TrackPosition getPosition(double dist) {
        if (0.0 <= dist && dist <= this.length) {
            return new Position(dist);
        }
        return null;
    }

    @Override
    public Shape getShape() {
        return this.line;
    }

    public class Position
    implements TrackPosition {
        private double normDist;
        private double x;
        private double y;

        public Position(double dist) {
            this.normDist = dist / LineTrack.this.length;
            this.x = LineTrack.this.p1.getX() + LineTrack.this.xLen * this.normDist;
            this.y = LineTrack.this.p1.getY() + LineTrack.this.yLen * this.normDist;
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getTangentSlope() {
            return LineTrack.this.slope;
        }

        @Override
        public double move(double dist) {
            if (this.normDist < 1.0) {
                this.normDist += dist / LineTrack.this.length;
                if (this.normDist > 1.0) {
                    this.x = LineTrack.this.p2.getX();
                    this.y = LineTrack.this.p2.getY();
                    return dist - (this.normDist - 1.0) * LineTrack.this.length;
                }
                this.x = LineTrack.this.p1.getX() + LineTrack.this.xLen * this.normDist;
                this.y = LineTrack.this.p1.getY() + LineTrack.this.yLen * this.normDist;
                return 0.0;
            }
            return dist;
        }

        public String toString() {
            return "LineTrack.Position(x=" + Constants.ONE_DEC.format(this.x) + ", y=" + Constants.ONE_DEC.format(this.y) + ", normDist=" + Constants.TWO_DEC.format(this.normDist) + ")";
        }
    }
}

