/*
 * Decompiled with CFR 0.152.
 */
package aim4.msg.udp;

import aim4.msg.i2v.Confirm;
import aim4.msg.i2v.Reject;
import aim4.msg.udp.UdpHeader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.SocketAddress;

public abstract class Proxy2RealAdapter {
    public static DatagramPacket toDatagramPacket(Confirm msg, SocketAddress sa, double currentTime) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = Proxy2RealAdapter.getDosWithHeader(baos, currentTime, UdpHeader.UdpMessageType.I2V_Confirm);
        assert (dos.size() == 12);
        dos.writeInt(msg.getReservationId());
        dos.writeFloat((float)(msg.getArrivalTime() - currentTime));
        dos.writeFloat((float)msg.getEarlyError());
        dos.writeFloat((float)msg.getLateError());
        dos.writeFloat((float)msg.getArrivalVelocity());
        double accel = msg.getAccelerationProfile().peek()[0];
        dos.writeFloat((float)accel);
        int udpPacketSize = 36;
        assert (baos.size() == udpPacketSize);
        DatagramPacket dp = new DatagramPacket(baos.toByteArray(), udpPacketSize, sa);
        return dp;
    }

    public static DatagramPacket toDatagramPacket(Reject msg, SocketAddress sa, double currentTime) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = Proxy2RealAdapter.getDosWithHeader(baos, currentTime, UdpHeader.UdpMessageType.I2V_Reject);
        assert (dos.size() == 12);
        int udpPacketSize = 12;
        assert (baos.size() == udpPacketSize);
        DatagramPacket dp = new DatagramPacket(baos.toByteArray(), udpPacketSize, sa);
        return dp;
    }

    public static DatagramPacket toDatagramPacket(double distToFrontVehicle, SocketAddress sa, double currentTime) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = Proxy2RealAdapter.getDosWithHeader(baos, currentTime, UdpHeader.UdpMessageType.I2V_DistToFrontVehicle);
        assert (dos.size() == 12);
        dos.writeFloat((float)distToFrontVehicle);
        int udpPacketSize = 16;
        assert (baos.size() == udpPacketSize);
        DatagramPacket dp = new DatagramPacket(baos.toByteArray(), udpPacketSize, sa);
        return dp;
    }

    public static DataOutputStream getDosWithHeader(ByteArrayOutputStream baos, double currentTime, UdpHeader.UdpMessageType type) throws IOException {
        DataOutputStream dos = new DataOutputStream(baos);
        UdpHeader header = new UdpHeader((float)currentTime, type);
        header.writeToDataOutputStream(dos);
        return dos;
    }
}

