/*
 * Decompiled with CFR 0.152.
 */
package aim4.msg.v2i;

import aim4.msg.v2i.V2IMessage;
import aim4.vehicle.VehicleSpec;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Request
extends V2IMessage {
    private int requestId;
    private VehicleSpecForRequestMsg spec;
    private List<Proposal> proposals;

    public Request(int sourceID, int destinationID, int requestId, VehicleSpecForRequestMsg spec, List<Proposal> proposals) {
        super(sourceID, destinationID);
        this.requestId = requestId;
        this.spec = spec;
        this.proposals = proposals;
        if (proposals.isEmpty()) {
            throw new IllegalArgumentException("Trajectory parameters can't be empty!");
        }
        this.messageType = V2IMessage.Type.REQUEST;
        this.size += 608 + 256 * proposals.size();
    }

    public Request(Request r) {
        super(r.getVin(), r.getImId());
        this.requestId = r.requestId;
        this.spec = new VehicleSpecForRequestMsg(r.spec);
        this.proposals = new LinkedList<Proposal>();
        for (Proposal p : r.proposals) {
            this.proposals.add(new Proposal(p));
        }
    }

    public int getRequestId() {
        return this.requestId;
    }

    public VehicleSpecForRequestMsg getSpec() {
        return this.spec;
    }

    public List<Proposal> getProposals() {
        return Collections.unmodifiableList(this.proposals);
    }

    public String toString() {
        String s = "Request(vin" + this.getVin() + " -> im" + this.getImId() + ",requestId=" + this.requestId + ",spec=...,proposals=\n";
        for (Proposal p : this.proposals) {
            s = s + "  " + p + "\n";
        }
        s = s + ")";
        return s;
    }

    public static class VehicleSpecForRequestMsg {
        private double maxAcceleration;
        private double maxDeceleration;
        private double minVelocity;
        private double length;
        private double width;
        private double frontAxleDisplacement;
        private double rearAxleDisplacement;
        private double maxSteeringAngle;
        private double maxTurnPerSecond;

        public VehicleSpecForRequestMsg(double maxAcceleration, double maxDeceleration, double minVelocity, double length, double width, double frontAxleDisplacement, double rearAxleDisplacement, double maxSteeringAngle, double maxTurnPerSecond) {
            this.maxAcceleration = maxAcceleration;
            this.maxDeceleration = maxDeceleration;
            this.minVelocity = minVelocity;
            this.length = length;
            this.width = width;
            this.frontAxleDisplacement = frontAxleDisplacement;
            this.rearAxleDisplacement = rearAxleDisplacement;
            this.maxSteeringAngle = maxSteeringAngle;
            this.maxTurnPerSecond = maxTurnPerSecond;
        }

        public VehicleSpecForRequestMsg(VehicleSpec vspec) {
            this.maxAcceleration = vspec.getMaxAcceleration();
            this.maxDeceleration = vspec.getMaxDeceleration();
            this.minVelocity = vspec.getMinVelocity();
            this.length = vspec.getLength();
            this.width = vspec.getWidth();
            this.frontAxleDisplacement = vspec.getFrontAxleDisplacement();
            this.rearAxleDisplacement = vspec.getRearAxleDisplacement();
            this.maxSteeringAngle = vspec.getMaxSteeringAngle();
            this.maxTurnPerSecond = vspec.getMaxTurnPerSecond();
        }

        public VehicleSpecForRequestMsg(VehicleSpecForRequestMsg spec) {
            this.maxAcceleration = spec.maxAcceleration;
            this.maxDeceleration = spec.maxDeceleration;
            this.minVelocity = spec.minVelocity;
            this.length = spec.length;
            this.width = spec.width;
            this.frontAxleDisplacement = spec.frontAxleDisplacement;
            this.rearAxleDisplacement = spec.rearAxleDisplacement;
            this.maxSteeringAngle = spec.maxSteeringAngle;
            this.maxTurnPerSecond = spec.maxTurnPerSecond;
        }

        public double getMaxAcceleration() {
            return this.maxAcceleration;
        }

        public double getMaxDeceleration() {
            return this.maxDeceleration;
        }

        public double getMinVelocity() {
            return this.minVelocity;
        }

        public double getLength() {
            return this.length;
        }

        public double getWidth() {
            return this.width;
        }

        public double getFrontAxleDisplacement() {
            return this.frontAxleDisplacement;
        }

        public double getRearAxleDisplacement() {
            return this.rearAxleDisplacement;
        }

        public double getMaxSteeringAngle() {
            return this.maxSteeringAngle;
        }

        public double getMaxTurnPerSecond() {
            return this.maxTurnPerSecond;
        }
    }

    public static class Proposal {
        private int arrivalLaneID;
        private int departureLaneID;
        private double arrivalTime;
        private double arrivalVelocity;
        private double maximumTurnVelocity;

        public Proposal(int arrivalLaneID, int departureLaneID, double arrivalTime, double arrivalVelocity, double maxTurnVelocity) {
            this.arrivalLaneID = arrivalLaneID;
            this.departureLaneID = departureLaneID;
            this.arrivalTime = arrivalTime;
            this.arrivalVelocity = arrivalVelocity;
            this.maximumTurnVelocity = maxTurnVelocity;
        }

        public Proposal(Proposal p) {
            this.arrivalLaneID = p.arrivalLaneID;
            this.departureLaneID = p.departureLaneID;
            this.arrivalTime = p.arrivalTime;
            this.arrivalVelocity = p.arrivalVelocity;
            this.maximumTurnVelocity = p.maximumTurnVelocity;
        }

        public int getArrivalLaneID() {
            return this.arrivalLaneID;
        }

        public int getDepartureLaneID() {
            return this.departureLaneID;
        }

        public double getArrivalTime() {
            return this.arrivalTime;
        }

        public double getArrivalVelocity() {
            return this.arrivalVelocity;
        }

        public double getMaximumTurnVelocity() {
            return this.maximumTurnVelocity;
        }

        public String toString() {
            return "Proposal(Lane" + String.format("%2d", this.arrivalLaneID) + " -> Lane" + String.format("%2d", this.departureLaneID) + " arrive at " + String.format("%.2f", this.arrivalTime) + " at speed " + String.format("%.2f", this.arrivalVelocity) + " (maxTurnVelocity:" + String.format("%.2f", this.maximumTurnVelocity) + "))";
        }
    }
}

