/*
 * Decompiled with CFR 0.152.
 */
package aim4.sim.setup;

import aim4.config.Constants;
import aim4.config.Debug;
import aim4.driver.pilot.V2IPilot;
import aim4.im.v2i.reservation.ReservationGridManager;
import aim4.map.GridMap;
import aim4.map.GridMapUtil;
import aim4.sim.AutoDriverOnlySimulator;
import aim4.sim.Simulator;
import aim4.sim.setup.BasicSimSetup;
import aim4.sim.setup.SimSetup;

public class AutoDriverOnlySimSetup
extends BasicSimSetup
implements SimSetup {
    private boolean isBaseLineMode = false;
    private boolean isBatchMode = false;
    private TrafficType trafficType = TrafficType.UNIFORM_RANDOM;
    private double hTrafficLevel;
    private double vTrafficLevel;
    private double staticBufferSize = 0.25;
    private double internalTileTimeBufferSize = 0.1;
    private double edgeTileTimeBufferSize;
    private boolean isEdgeTileTimeBufferEnabled = true;
    private double granularity = 1.0;
    private double processingInterval = 2.0;
    private String trafficVolumeFileName = null;

    public AutoDriverOnlySimSetup(BasicSimSetup basicSimSetup) {
        super(basicSimSetup);
    }

    public AutoDriverOnlySimSetup(int columns, int rows, double laneWidth, double speedLimit, int lanesPerRoad, double medianSize, double distanceBetween, double trafficLevel, double stopDistBeforeIntersection) {
        super(columns, rows, laneWidth, speedLimit, lanesPerRoad, medianSize, distanceBetween, trafficLevel, stopDistBeforeIntersection);
    }

    public void setIsBaseLineMode(boolean b) {
        this.isBaseLineMode = b;
    }

    public void setIsBatchMode(boolean b) {
        this.isBatchMode = b;
    }

    public void setBatchModeProcessingInterval(double processingInterval) {
        this.processingInterval = processingInterval;
    }

    public void setUniformRandomTraffic(double trafficLevel) {
        this.trafficType = TrafficType.UNIFORM_RANDOM;
        this.trafficLevel = trafficLevel;
    }

    public void setUniformTurnBasedTraffic(double trafficLevel) {
        this.trafficType = TrafficType.UNIFORM_TURNBASED;
        this.trafficLevel = trafficLevel;
    }

    public void setHVdirectionalRandomTraffic(double hTrafficLevel, double vTrafficLevel) {
        this.trafficType = TrafficType.HVDIRECTIONAL_RANDOM;
        this.hTrafficLevel = hTrafficLevel;
        this.vTrafficLevel = vTrafficLevel;
    }

    public void setTrafficVolume(String trafficVolumeFileName) {
        this.trafficType = TrafficType.FILE;
        this.trafficVolumeFileName = trafficVolumeFileName;
    }

    public void setBuffers(double staticBufferSize, double internalTileTimeBufferSize, double edgeTileTimeBufferSize, boolean isEdgeTileTimeBufferEnabled, double granularity) {
        this.staticBufferSize = staticBufferSize;
        this.internalTileTimeBufferSize = internalTileTimeBufferSize;
        this.edgeTileTimeBufferSize = edgeTileTimeBufferSize;
        this.isEdgeTileTimeBufferEnabled = isEdgeTileTimeBufferEnabled;
        this.granularity = granularity;
    }

    @Override
    public Simulator getSimulator() {
        double currentTime = 0.0;
        GridMap layout = new GridMap(currentTime, this.numOfColumns, this.numOfRows, this.laneWidth, this.speedLimit, this.lanesPerRoad, this.medianSize, this.distanceBetween);
        try {
            this.edgeTileTimeBufferSize = Constants.getEdgeTileTimeBufferBasedOnVelocity(this.speedLimit);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            V2IPilot.MINIMUM_FOLLOWING_DISTANCE = Constants.getMinimumFollowingDistanceBasedOnVelocity(this.speedLimit);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ReservationGridManager.Config gridConfig = new ReservationGridManager.Config(0.02, 0.02, this.staticBufferSize, this.internalTileTimeBufferSize, this.edgeTileTimeBufferSize, this.isEdgeTileTimeBufferEnabled, this.granularity);
        Debug.SHOW_VEHICLE_COLOR_BY_MSG_STATE = true;
        if (!this.isBaseLineMode) {
            if (this.isBatchMode) {
                GridMapUtil.setBatchManagers(layout, currentTime, gridConfig, this.processingInterval);
            } else {
                GridMapUtil.setFCFSManagers(layout, currentTime, gridConfig);
            }
            switch (this.trafficType) {
                case UNIFORM_RANDOM: {
                    GridMapUtil.setUniformRandomSpawnPoints(layout, this.trafficLevel);
                    break;
                }
                case UNIFORM_TURNBASED: {
                    GridMapUtil.setUniformTurnBasedSpawnPoints(layout, this.trafficLevel);
                    break;
                }
                case HVDIRECTIONAL_RANDOM: {
                    GridMapUtil.setDirectionalSpawnPoints(layout, this.hTrafficLevel, this.vTrafficLevel);
                    break;
                }
                case FILE: {
                    GridMapUtil.setUniformRatioSpawnPoints(layout, this.trafficVolumeFileName);
                }
            }
        } else {
            GridMapUtil.setFCFSManagers(layout, currentTime, gridConfig);
            GridMapUtil.setBaselineSpawnPoints(layout, 12.0);
        }
        V2IPilot.DEFAULT_STOP_DISTANCE_BEFORE_INTERSECTION = this.stopDistBeforeIntersection;
        return new AutoDriverOnlySimulator(layout);
    }

    public static enum TrafficType {
        UNIFORM_RANDOM,
        UNIFORM_TURNBASED,
        HVDIRECTIONAL_RANDOM,
        FILE;

    }
}

