/*
 * Decompiled with CFR 0.152.
 */
package aim4.util;

import aim4.util.Util;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public final class GeomMath {
    public static final double QUARTER_PI = 0.7853981633974483;
    public static final double HALF_PI = 1.5707963267948966;
    public static final double PI = Math.PI;
    public static final double ONE_AND_HALF_PI = 4.71238898038469;
    public static final double TWO_PI = Math.PI * 2;

    public static String ordinalize(int num) {
        String suffix;
        if (num % 100 == 11 || num % 100 == 12 || num % 100 == 13) {
            suffix = "th";
        } else {
            switch (num % 10) {
                case 1: {
                    suffix = "st";
                    break;
                }
                case 2: {
                    suffix = "nd";
                    break;
                }
                case 3: {
                    suffix = "rd";
                    break;
                }
                default: {
                    suffix = "th";
                }
            }
        }
        return num + suffix;
    }

    public static double canonicalAngle(double angle) {
        return angle - Math.floor(angle / (Math.PI * 2)) * (Math.PI * 2);
    }

    public static double angleToPoint(Point2D p, Point2D startPoint) {
        return Math.atan2(p.getY() - startPoint.getY(), p.getX() - startPoint.getX());
    }

    public static Point2D polarAdd(Point2D p, double r, double theta) {
        return new Point2D.Double(p.getX() + Math.cos(theta) * r, p.getY() + Math.sin(theta) * r);
    }

    public static Point2D subtract(Point2D p1, Point2D p2) {
        return new Point2D.Double(p1.getX() - p2.getX(), p1.getY() - p2.getY());
    }

    public static double dotProduct(Point2D p1, Point2D p2) {
        return p1.getX() * p2.getX() + p1.getY() * p2.getY();
    }

    public static double crossProduct(Point2D p1, Point2D p2) {
        return p1.getX() * p2.getY() - p2.getX() * p1.getY();
    }

    public static Point2D findLineLineIntersection(Line2D l1, Line2D l2) {
        return GeomMath.findLineLineIntersection(l1.getX1(), l1.getY1(), l1.getX2(), l1.getY2(), l2.getX1(), l2.getY1(), l2.getX2(), l2.getY2());
    }

    public static Point2D findLineLineIntersection(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        double d12 = GeomMath.determinant(x1, y1, x2, y2);
        double d34 = GeomMath.determinant(x3, y3, x4, y4);
        double diffx1x2 = x1 - x2;
        double diffy1y2 = y1 - y2;
        double diffx3x4 = x3 - x4;
        double diffy3y4 = y3 - y4;
        double d1234 = GeomMath.determinant(diffx1x2, diffy1y2, diffx3x4, diffy3y4);
        if (d1234 == 0.0) {
            ArrayList<Point2D.Double> candidates = new ArrayList<Point2D.Double>(4);
            candidates.add(new Point2D.Double(x1, y1));
            candidates.add(new Point2D.Double(x2, y2));
            candidates.add(new Point2D.Double(x3, y3));
            candidates.add(new Point2D.Double(x4, y4));
            Line2D.Double l1 = new Line2D.Double(x1, y1, x2, y2);
            Line2D.Double l2 = new Line2D.Double(x3, y3, x4, y4);
            Point2D retval = null;
            double dist = Double.MAX_VALUE;
            for (Point2D point2D : candidates) {
                if (l1.ptSegDist(point2D) != 0.0 || l2.ptSegDist(point2D) != 0.0 || !(((Line2D)l1).getP1().distance(point2D) < dist)) continue;
                retval = point2D;
                dist = ((Line2D)l1).getP1().distance(point2D);
            }
            return retval;
        }
        double x = GeomMath.determinant(d12, diffx1x2, d34, diffx3x4) / d1234;
        double y = GeomMath.determinant(d12, diffy1y2, d34, diffy3y4) / d1234;
        return new Point2D.Double(x, y);
    }

    public static IntersectionPoint findLineLineIntersection(Point2D p1, double slope1, Point2D p2, double slope2) {
        double dx1 = Math.cos(slope1);
        double dy1 = Math.sin(slope1);
        double dx2 = Math.cos(slope2);
        double dy2 = Math.sin(slope2);
        double a1 = dx1;
        double a2 = -dx2;
        double a3 = dy1;
        double a4 = -dy2;
        double c1 = p2.getX() - p1.getX();
        double c2 = p2.getY() - p1.getY();
        double det = GeomMath.determinant(a1, a2, a3, a4);
        double t1 = (a4 * c1 - a2 * c2) / det;
        double t2 = (-a3 * c1 + a1 * c2) / det;
        Point2D.Double p3 = new Point2D.Double(p1.getX() + t1 * dx1, p1.getY() + t1 * dy1);
        assert (Util.isDoubleEqual(((Point2D)p3).getX(), p2.getX() + t2 * dx2));
        assert (Util.isDoubleEqual(((Point2D)p3).getY(), p2.getY() + t2 * dy2));
        return new IntersectionPoint(p3, t1, t2);
    }

    public static List<List<Point2D>> polygonalSubShapeVertices(Shape s) {
        ArrayList<List<Point2D>> answ = new ArrayList<List<Point2D>>();
        ArrayList<Point2D.Double> currList = new ArrayList<Point2D.Double>();
        int lastMoveType = 0;
        double[] pts = new double[6];
        PathIterator iter = s.getPathIterator(new AffineTransform());
        while (!iter.isDone()) {
            int moveType = iter.currentSegment(pts);
            switch (moveType) {
                case 0: {
                    if (lastMoveType != 4) break;
                    currList.remove(0);
                    break;
                }
                case 1: {
                    break;
                }
                case 4: {
                    answ.add(currList);
                    currList = new ArrayList();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Shape is not polygonal!");
                }
            }
            currList.add(new Point2D.Double(pts[0], pts[1]));
            lastMoveType = moveType;
            iter.next();
        }
        return answ;
    }

    public static List<Line2D> polygonalShapePerimeterSegments(Shape s) {
        ArrayList<Line2D> perimeterSegments = new ArrayList<Line2D>();
        for (List<Point2D> vtcs : GeomMath.polygonalSubShapeVertices(s)) {
            for (int i = 0; i < vtcs.size(); ++i) {
                Point2D p1 = vtcs.get(i);
                Point2D p2 = vtcs.get((i + 1) % vtcs.size());
                perimeterSegments.add(new Line2D.Double(p1, p2));
            }
        }
        return perimeterSegments;
    }

    public static List<Double> polygonalShapeAreas(Shape s) {
        ArrayList<Double> answ = new ArrayList<Double>();
        for (List<Point2D> vtcs : GeomMath.polygonalSubShapeVertices(s)) {
            double twiceCurrArea = 0.0;
            for (int i = 0; i < vtcs.size(); ++i) {
                Point2D p1 = vtcs.get(i);
                Point2D p2 = vtcs.get((i + 1) % vtcs.size());
                twiceCurrArea += p1.getX() * p2.getY() - p2.getX() * p1.getY();
            }
            answ.add(twiceCurrArea / 2.0);
        }
        return answ;
    }

    public static Point2D polygonalShapeCentroid(Shape s) {
        List<Double> pAreas = GeomMath.polygonalShapeAreas(s);
        List<List<Point2D>> pVtcs = GeomMath.polygonalSubShapeVertices(s);
        double totalArea = 0.0;
        double cx = 0.0;
        double cy = 0.0;
        for (int i = 0; i < pAreas.size(); ++i) {
            totalArea += Math.abs(pAreas.get(i));
            double cxi = 0.0;
            double cyi = 0.0;
            List<Point2D> vtcs = pVtcs.get(i);
            for (int j = 0; j < vtcs.size(); ++j) {
                Point2D p1 = vtcs.get(j);
                Point2D p2 = vtcs.get((j + 1) % vtcs.size());
                cxi += (p1.getX() + p2.getX()) * (p1.getX() * p2.getY() - p2.getX() * p1.getY());
                cyi += (p1.getY() + p2.getY()) * (p1.getX() * p2.getY() - p2.getX() * p1.getY());
            }
            cx += Math.signum(pAreas.get(i)) * cxi / 6.0;
            cy += Math.signum(pAreas.get(i)) * cyi / 6.0;
        }
        return new Point2D.Double(cx / totalArea, cy / totalArea);
    }

    public static Point2D centroid(List<Point2D> points) {
        double cx = 0.0;
        double cy = 0.0;
        for (Point2D p : points) {
            cx += p.getX();
            cy += p.getY();
        }
        return new Point2D.Double(cx / (double)points.size(), cy / (double)points.size());
    }

    public static Area filledArea(Shape s) {
        Area answ = new Area();
        for (Area a : GeomMath.subareas(s)) {
            answ.add(a);
        }
        return answ;
    }

    public static List<Area> subareas(Shape s) {
        ArrayList<Area> answ = new ArrayList<Area>();
        for (List<Point2D> vtcs : GeomMath.polygonalSubShapeVertices(s)) {
            GeneralPath path = new GeneralPath();
            path.moveTo((float)vtcs.get(0).getX(), (float)vtcs.get(0).getY());
            for (int i = 1; i < vtcs.size(); ++i) {
                path.lineTo((float)vtcs.get(i).getX(), (float)vtcs.get(i).getY());
            }
            path.closePath();
            answ.add(new Area(path));
        }
        return answ;
    }

    public static double quadraticFormula(double a, double b, double c) {
        double sqrtDiscriminant = Math.sqrt(Math.pow(b, 2.0) - 4.0 * a * c);
        double plusAnsw = (-b + sqrtDiscriminant) / (2.0 * a);
        double minusAnsw = (-b - sqrtDiscriminant) / (2.0 * a);
        return GeomMath.minNonnegative(plusAnsw, minusAnsw);
    }

    public static boolean intervalsOverlap(double t1start, double t1end, double t2start, double t2end) {
        return t2start >= t1start && t2start <= t1end || t1start >= t2start && t1start <= t2end;
    }

    public static double angleDiff(double ang1, double ang2) {
        double absoluteDifference = Math.abs(ang1 - ang2);
        return Math.min(absoluteDifference, Math.PI * 2 - absoluteDifference);
    }

    private static double determinant(double a, double b, double c, double d) {
        return a * d - b * c;
    }

    private static double minNonnegative(double a, double b) {
        if (a > b) {
            if (b >= 0.0) {
                return b;
            }
            return a;
        }
        if (a >= 0.0) {
            return a;
        }
        return b;
    }

    private GeomMath() {
    }

    public static class IntersectionPoint {
        private Point2D p;
        private double t1;
        private double t2;

        public IntersectionPoint(Point2D p, double t1, double t2) {
            this.p = p;
            this.t1 = t1;
            this.t2 = t2;
        }

        public Point2D getPoint() {
            return this.p;
        }

        public double getT1() {
            return this.t1;
        }

        public double getT2() {
            return this.t2;
        }
    }
}

