/*
 * Decompiled with CFR 0.152.
 */
package aim4.util;

import aim4.util.GeomMath;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class GeomUtil {
    public Shape convertLineIntoRectangle(Line2D line, double halfWidth) {
        double heading = GeomMath.canonicalAngle(Math.atan2(line.getY2() - line.getY1(), line.getX2() - line.getX1()));
        GeneralPath result = new GeneralPath();
        double xDifferential = halfWidth * Math.cos(heading + 1.5707963267948966);
        double yDifferential = halfWidth * Math.sin(heading + 1.5707963267948966);
        result.moveTo(line.getX1() + xDifferential, line.getY1() + yDifferential);
        result.lineTo(line.getX2() + xDifferential, line.getY2() + yDifferential);
        result.lineTo(line.getX2() - xDifferential, line.getY2() - yDifferential);
        result.lineTo(line.getX1() - xDifferential, line.getY1() - yDifferential);
        result.closePath();
        return result;
    }

    public Shape convertArcIntoFan(Arc2D arc, double halfWidth) {
        double x = arc.getX();
        double y = arc.getY();
        double w = arc.getWidth();
        double h = arc.getHeight();
        double start = arc.getAngleStart();
        double extent = arc.getAngleExtent();
        Arc2D.Double arc1 = new Arc2D.Double(x - halfWidth, y - halfWidth, w + 2.0 * halfWidth, h + 2.0 * halfWidth, start, extent, 0);
        Arc2D.Double arc2 = new Arc2D.Double(x + halfWidth, y + halfWidth, w - 2.0 * halfWidth, h - 2.0 * halfWidth, start + extent, -extent, 0);
        GeneralPath result = new GeneralPath();
        result.append(arc1, false);
        result.append(arc2, true);
        result.closePath();
        return result;
    }

    public static Shape convertPointsToShape(Point2D[] points) {
        GeneralPath result = new GeneralPath();
        result.moveTo((float)points[0].getX(), (float)points[0].getY());
        for (int i = 1; i < points.length; ++i) {
            result.lineTo((float)points[i].getX(), (float)points[i].getY());
        }
        result.closePath();
        return result;
    }

    private GeomUtil() {
    }
}

