/*
 * Decompiled with CFR 0.152.
 */
package aim4.util;

import aim4.util.Registry;
import java.util.HashMap;

public class HashMapRegistry<T>
implements Registry<T> {
    private int initId;
    private int nextId;
    private HashMap<Integer, T> idToObj = new HashMap();

    public HashMapRegistry() {
        this(0);
    }

    public HashMapRegistry(int initId) {
        this.initId = initId;
        this.nextId = initId;
    }

    @Override
    public int register(T obj) {
        int id = this.nextId++;
        this.idToObj.put(id, obj);
        return id;
    }

    @Override
    public boolean isIdExist(int id) {
        return this.initId <= id && id < this.nextId;
    }

    @Override
    public T get(int id) {
        T obj = this.idToObj.get(id);
        if (obj == null) {
            this.idToObj.remove(id);
            return null;
        }
        return obj;
    }

    @Override
    public int getNewId() {
        int id = this.nextId++;
        this.idToObj.put(id, null);
        return id;
    }

    @Override
    public void set(int id, T obj) {
        assert (this.idToObj.containsKey(id));
        this.idToObj.put(id, obj);
    }

    @Override
    public void setNull(int id) {
        this.idToObj.remove(id);
    }
}

