/*
 * Decompiled with CFR 0.152.
 */
package aim4.util;

import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class TiledArea {
    private final Area area;
    private final Rectangle2D rectangle;
    private final int xNum;
    private final int yNum;
    private final double xLength;
    private final double yLength;
    private final Tile[][] tiles;
    private final ArrayList<Tile> idToTiles;
    private int numberOfTiles;

    public TiledArea(Area area, double length) {
        this(area, length, length);
    }

    public TiledArea(Area area, double xLength, double yLength) {
        this.area = area;
        this.rectangle = area.getBounds2D();
        this.xLength = xLength;
        this.yLength = yLength;
        this.xNum = (int)(this.rectangle.getWidth() / xLength) + 1;
        this.yNum = (int)(this.rectangle.getHeight() / yLength) + 1;
        this.tiles = new Tile[this.xNum][this.yNum];
        this.idToTiles = new ArrayList(this.xNum * this.yNum);
        this.createTiles();
        this.identifyEdgeTiles();
    }

    private void createTiles() {
        this.numberOfTiles = 0;
        for (int x = 0; x < this.xNum; ++x) {
            for (int y = 0; y < this.yNum; ++y) {
                double xOffset = (double)x * this.xLength;
                double yOffset = (double)y * this.yLength;
                double width = Math.min(this.xLength, this.rectangle.getWidth() - xOffset);
                double height = Math.min(this.yLength, this.rectangle.getHeight() - yOffset);
                Rectangle2D.Double tileRect = new Rectangle2D.Double(this.rectangle.getMinX() + xOffset, this.rectangle.getMinY() + yOffset, width, height);
                if (!this.area.intersects(tileRect)) continue;
                this.tiles[x][y] = new Tile(tileRect, x, y, this.numberOfTiles);
                this.idToTiles.add(this.tiles[x][y]);
                ++this.numberOfTiles;
            }
        }
    }

    private void identifyEdgeTiles() {
        for (int x = 0; x < this.xNum; ++x) {
            for (int y = 0; y < this.yNum; ++y) {
                if (this.tiles[x][y] == null) continue;
                if (x == 0 || y == 0 || x == this.xNum - 1 || y == this.yNum - 1) {
                    this.tiles[x][y].setEdgeTile(true);
                    continue;
                }
                if (this.tiles[x - 1][y - 1] != null && this.tiles[x][y - 1] != null && this.tiles[x + 1][y - 1] != null && this.tiles[x - 1][y] != null && this.tiles[x + 1][y] != null && this.tiles[x - 1][y + 1] != null && this.tiles[x][y + 1] != null && this.tiles[x + 1][y + 1] != null) continue;
                this.tiles[x][y].setEdgeTile(true);
            }
        }
    }

    public Area getArea() {
        return this.area;
    }

    public int getXNum() {
        return this.xNum;
    }

    public int getYNum() {
        return this.yNum;
    }

    public double getXLength() {
        return this.xLength;
    }

    public double getYLength() {
        return this.yLength;
    }

    public Tile getTile(int x, int y) {
        return this.tiles[x][y];
    }

    public int getNumberOfTiles() {
        return this.numberOfTiles;
    }

    public boolean areTilesSquare() {
        return this.yLength == this.xLength;
    }

    public Tile getTileById(int id) {
        return this.idToTiles.get(id);
    }

    public List<Tile> findOccupiedTiles(Shape shape) {
        ArrayList<Tile> occupiedTiles = new ArrayList<Tile>();
        Rectangle2D boundingBox = shape.getBounds2D();
        int firstColumn = Math.max(0, (int)((boundingBox.getMinX() - this.rectangle.getMinX()) / this.xLength));
        int lastColumn = Math.min(this.xNum - 1, (int)((boundingBox.getMaxX() - this.rectangle.getMinX()) / this.xLength));
        int firstRow = Math.max(0, (int)((boundingBox.getMinY() - this.rectangle.getMinY()) / this.yLength));
        int lastRow = Math.min(this.yNum - 1, (int)((boundingBox.getMaxY() - this.rectangle.getMinY()) / this.yLength));
        for (int c = firstColumn; c <= lastColumn; ++c) {
            for (int r = firstRow; r <= lastRow; ++r) {
                if (this.tiles[c][r] == null || !shape.intersects(this.tiles[c][r].getRectangle())) continue;
                occupiedTiles.add(this.tiles[c][r]);
            }
        }
        return occupiedTiles;
    }

    public static class Tile {
        private final Rectangle2D rectangle;
        private final int x;
        private final int y;
        private final int id;
        private boolean edgeTile = false;

        public Tile(Rectangle2D rectangle, int x, int y, int id) {
            this.rectangle = rectangle;
            this.x = x;
            this.y = y;
            this.id = id;
        }

        public Rectangle2D getRectangle() {
            return this.rectangle;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getId() {
            return this.id;
        }

        public boolean isEdgeTile() {
            return this.edgeTile;
        }

        public void setEdgeTile(boolean edgeTile) {
            this.edgeTile = edgeTile;
        }
    }
}

