/*
 * Decompiled with CFR 0.152.
 */
package aim4.util;

import aim4.config.Condor;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class Util {
    public static long randSeed = new Random().nextLong();
    public static final Random random = new Random(randSeed);

    public static boolean nearlyEqual(double a, double b, double epsilon) {
        double absA = Math.abs(a);
        double absB = Math.abs(b);
        double diff = Math.abs(a - b);
        if (a * b == 0.0) {
            return diff < epsilon * epsilon;
        }
        return diff / (absA + absB) < epsilon;
    }

    public static boolean isDoubleZero(double a) {
        return Math.abs(a) <= 1.0E-10;
    }

    public static boolean isDoubleNotZero(double a) {
        return Math.abs(a) > 1.0E-10;
    }

    public static boolean isDoubleEqual(double a, double b) {
        return Math.abs(a - b) <= 1.0E-10;
    }

    public static boolean isDoubleNotEqual(double a, double b) {
        return Math.abs(a - b) > 1.0E-10;
    }

    public static boolean isDoubleEqual(double a, double b, double precision) {
        return Math.abs(a - b) <= precision;
    }

    public static boolean isDoubleNotEqual(double a, double b, double precision) {
        return Math.abs(a - b) > precision;
    }

    public static boolean isDoubleEqualOrGreater(double a, double b) {
        return a > b || Util.isDoubleEqual(a, b);
    }

    public static boolean isDoubleEqualOrLess(double a, double b) {
        return a < b || Util.isDoubleEqual(a, b);
    }

    public static double constrain(double inputValue, double minValue, double maxValue) {
        if (inputValue > maxValue) {
            return maxValue;
        }
        if (inputValue < minValue) {
            return minValue;
        }
        return inputValue;
    }

    public static double recenter(double inputValue, double minValue, double maxValue) {
        while (inputValue < minValue) {
            inputValue += maxValue - minValue;
        }
        while (inputValue > maxValue) {
            inputValue -= maxValue - minValue;
        }
        return inputValue;
    }

    public static double sum(Iterable<Double> as) {
        double sum = 0.0;
        for (double a : as) {
            sum += a;
        }
        return sum;
    }

    public static double sum(double[] as) {
        double sum = 0.0;
        for (double a : as) {
            sum += a;
        }
        return sum;
    }

    public static int randomIndex(double[] distribution) {
        double a = random.nextDouble();
        for (int i = 0; i < distribution.length; ++i) {
            if (!((a -= distribution[i]) < 0.0)) continue;
            return i;
        }
        throw new IllegalArgumentException("Invalid proportions.");
    }

    public static int randomIndex(List<Double> distribution) {
        double a = random.nextDouble();
        for (int i = 0; i < distribution.size(); ++i) {
            if (!((a -= distribution.get(i).doubleValue()) < 0.0)) continue;
            return i;
        }
        throw new IllegalArgumentException("Invalid proportions.");
    }

    public static String concatenate(List<String> strings, String sep) {
        String str = "";
        for (String s : strings) {
            if (str.equals("")) {
                str = s;
                continue;
            }
            str = str + sep + s;
        }
        return str;
    }

    public static String concatenate(String[] strings, String sep) {
        return Util.concatenate(Arrays.asList(strings), sep);
    }

    public static List<String> readFileToStrArray(String inFileName) throws IOException {
        String strLine;
        LinkedList<String> result = new LinkedList<String>();
        InputStream fstream = Util.class.getResourceAsStream(inFileName);
        if (fstream == null) {
            System.err.printf("Fuck this: %s\n", inFileName);
        }
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        while ((strLine = br.readLine()) != null) {
            result.add(strLine);
        }
        in.close();
        return new ArrayList<String>(result);
    }

    private Util() {
    }

    static {
        if (Condor.IS_CONDOR_EXIST) {
            try {
                Thread.sleep(Condor.CONDOR_ID * 10);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            randSeed = random.nextLong() + (long)Condor.CONDOR_ID;
            random.setSeed(randSeed);
        }
    }
}

