/*
 * Decompiled with CFR 0.152.
 */
package aim4.vehicle;

import aim4.config.Constants;
import aim4.util.Util;
import java.util.LinkedList;
import java.util.List;

public class AccelSchedule {
    private List<TimeAccel> timeAccelList = new LinkedList<TimeAccel>();

    public void add(double time, double accel) {
        this.timeAccelList.add(new TimeAccel(time, accel));
    }

    public int size() {
        return this.timeAccelList.size();
    }

    public List<TimeAccel> getList() {
        return this.timeAccelList;
    }

    public double calcFinalVelocity(double v1) {
        TimeAccel lastTa = null;
        for (TimeAccel ta : this.timeAccelList) {
            if (lastTa != null) {
                v1 += (ta.getTime() - lastTa.getTime()) * lastTa.getAcceleration();
            }
            lastTa = ta;
        }
        return v1;
    }

    public boolean checkVelocityUpperLimit(double v1, double vTop) {
        if (!Util.isDoubleEqualOrLess(v1, vTop)) {
            return false;
        }
        TimeAccel lastTa = null;
        for (TimeAccel ta : this.timeAccelList) {
            if (lastTa != null && Util.isDoubleNotEqual(v1 += (ta.getTime() - lastTa.getTime()) * lastTa.getAcceleration(), vTop) && v1 > vTop) {
                return false;
            }
            lastTa = ta;
        }
        return true;
    }

    public double calcTotalDistance(double time1, double v1, double timeEnd) {
        TimeAccel ta;
        TimeAccel ta2;
        int i;
        assert (time1 < timeEnd);
        double accel = 0.0;
        for (i = 0; i < this.timeAccelList.size() && !(time1 < (ta2 = this.timeAccelList.get(i)).getTime()); ++i) {
            accel = ta2.getAcceleration();
        }
        double time = time1;
        double v = v1;
        double dTotal = 0.0;
        while (i < this.timeAccelList.size() && !(timeEnd < (ta = this.timeAccelList.get(i)).getTime())) {
            double t = ta.getTime() - time;
            double v2 = v + accel * t;
            dTotal += t * (v + v2) / 2.0;
            time = ta.getTime();
            v = v2;
            accel = ta.getAcceleration();
            ++i;
        }
        double t = timeEnd - time;
        double v2 = v + accel * t;
        return dTotal += t * (v + v2) / 2.0;
    }

    public double[] calcFinalDistanceAndVelocity(double time1, double v1, double timeEnd) {
        TimeAccel ta;
        TimeAccel ta2;
        int i;
        assert (time1 < timeEnd);
        double accel = 0.0;
        for (i = 0; i < this.timeAccelList.size() && !(time1 < (ta2 = this.timeAccelList.get(i)).getTime()); ++i) {
            accel = ta2.getAcceleration();
        }
        double time = time1;
        double v = v1;
        double dTotal = 0.0;
        while (i < this.timeAccelList.size() && !(timeEnd < (ta = this.timeAccelList.get(i)).getTime())) {
            double t = ta.getTime() - time;
            double v2 = v + accel * t;
            dTotal += t * (v + v2) / 2.0;
            time = ta.getTime();
            v = v2;
            accel = ta.getAcceleration();
            ++i;
        }
        double t = timeEnd - time;
        double v2 = v + accel * t;
        return new double[]{dTotal += t * (v + v2) / 2.0, v2};
    }

    public double[] calcFinalTimeAndVelocity(double time1, double v1, double dTotal) {
        double v2;
        TimeAccel ta;
        double t;
        double d;
        TimeAccel ta2;
        int i;
        double accel = 0.0;
        for (i = 0; i < this.timeAccelList.size() && !(time1 < (ta2 = this.timeAccelList.get(i)).getTime()); ++i) {
            accel = ta2.getAcceleration();
        }
        double time = time1;
        double v = v1;
        double dSum = 0.0;
        while (i < this.timeAccelList.size() && !(dSum + (d = (t = (ta = this.timeAccelList.get(i)).getTime() - time) * (v + (v2 = v + accel * t)) / 2.0) >= dTotal)) {
            dSum += d;
            time = ta.getTime();
            v = v2;
            accel = ta.getAcceleration();
            ++i;
        }
        double d2 = dTotal - dSum;
        if (d2 > 0.0) {
            if (Util.isDoubleZero(accel)) {
                return null;
            }
            if (2.0 * accel * d2 + v * v >= 0.0) {
                double vEnd = Math.sqrt(2.0 * accel * d2 + v * v);
                double t2 = (vEnd - v) / accel;
                double timeEnd = time + t2;
                return new double[]{timeEnd, vEnd};
            }
            return null;
        }
        assert (Util.isDoubleZero(d2));
        return new double[]{time, v};
    }

    public String toString() {
        String s = "";
        boolean isFirst = true;
        for (TimeAccel ta : this.timeAccelList) {
            if (isFirst) {
                s = s + "[";
                isFirst = false;
            } else {
                s = s + ",";
            }
            s = s + ta.toString();
        }
        s = s + "]";
        return s;
    }

    public static class TimeAccel {
        private double time;
        private double acceleration;

        public TimeAccel(double time, double acceleration) {
            this.time = time;
            this.acceleration = acceleration;
        }

        public double getTime() {
            return this.time;
        }

        public double getAcceleration() {
            return this.acceleration;
        }

        public String toString() {
            return "(" + Constants.TWO_DEC.format(this.acceleration) + " at time " + Constants.TWO_DEC.format(this.time) + ")";
        }
    }
}

