/*
 * Decompiled with CFR 0.152.
 */
package aim4.vehicle;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class VehicleSpec {
    private String name;
    private double maxAcceleration;
    private double maxDeceleration;
    private double maxVelocity;
    private double minVelocity;
    private double length;
    private double width;
    private double frontAxleDisplacement;
    private double rearAxleDisplacement;
    private double wheelSpan;
    private double wheelRadius;
    private double wheelWidth;
    private double maxSteeringAngle;
    private double maxTurnPerSecond;
    private double maxTurnPerCycle;
    private double radius;
    private double halfWidth;
    private double halfLength;
    private double wheelbase;

    public VehicleSpec(String name, double maxAcceleration, double maxDeceleration, double maxVelocity, double minVelocity, double length, double width, double frontAxleDisplacement, double rearAxleDisplacement, double wheelSpan, double wheelRadius, double wheelWidth, double maxSteeringAngle, double maxTurnPerSecond) {
        this.name = name;
        this.maxAcceleration = maxAcceleration;
        this.maxDeceleration = maxDeceleration;
        this.maxVelocity = maxVelocity;
        this.minVelocity = minVelocity;
        this.length = length;
        this.width = width;
        this.frontAxleDisplacement = frontAxleDisplacement;
        this.rearAxleDisplacement = rearAxleDisplacement;
        this.wheelSpan = wheelSpan;
        this.wheelRadius = wheelRadius;
        this.wheelWidth = wheelWidth;
        this.maxSteeringAngle = maxSteeringAngle;
        this.maxTurnPerSecond = maxTurnPerSecond;
        this.maxTurnPerCycle = maxTurnPerSecond / 50.0;
        this.radius = Math.sqrt(length * length + width * width) / 2.0;
        this.halfWidth = width / 2.0;
        this.halfLength = length / 2.0;
        this.wheelbase = rearAxleDisplacement - frontAxleDisplacement;
    }

    public void assign(VehicleSpec spec) {
        this.name = spec.name;
        this.maxAcceleration = spec.maxAcceleration;
        this.maxDeceleration = spec.maxDeceleration;
        this.maxVelocity = spec.maxVelocity;
        this.minVelocity = spec.minVelocity;
        this.length = spec.length;
        this.width = spec.width;
        this.frontAxleDisplacement = spec.frontAxleDisplacement;
        this.rearAxleDisplacement = spec.rearAxleDisplacement;
        this.wheelSpan = spec.wheelSpan;
        this.wheelRadius = spec.wheelRadius;
        this.wheelWidth = spec.wheelWidth;
        this.maxSteeringAngle = spec.wheelWidth;
        this.maxTurnPerSecond = spec.maxTurnPerSecond;
        this.maxTurnPerCycle = spec.maxTurnPerCycle;
        this.radius = spec.radius;
        this.halfWidth = spec.halfWidth;
        this.halfLength = spec.halfLength;
        this.wheelbase = spec.wheelbase;
    }

    public String getName() {
        return this.name;
    }

    public double getMaxAcceleration() {
        return this.maxAcceleration;
    }

    public double getMaxDeceleration() {
        return this.maxDeceleration;
    }

    public double getMaxVelocity() {
        return this.maxVelocity;
    }

    public double getMinVelocity() {
        return this.minVelocity;
    }

    public double getLength() {
        return this.length;
    }

    public double getWidth() {
        return this.width;
    }

    public double getFrontAxleDisplacement() {
        return this.frontAxleDisplacement;
    }

    public double getRearAxleDisplacement() {
        return this.rearAxleDisplacement;
    }

    public double getWheelSpan() {
        return this.wheelSpan;
    }

    public double getWheelRadius() {
        return this.wheelRadius;
    }

    public double getWheelWidth() {
        return this.wheelWidth;
    }

    public double getMaxSteeringAngle() {
        return this.maxSteeringAngle;
    }

    public double getMaxTurnPerSecond() {
        return this.maxTurnPerSecond;
    }

    public double getMaxTurnPerCycle() {
        return this.maxTurnPerCycle;
    }

    public double getRadius() {
        return this.radius;
    }

    public double getHalfWidth() {
        return this.halfWidth;
    }

    public double getHalfLength() {
        return this.halfLength;
    }

    public double getWheelbase() {
        return this.wheelbase;
    }

    public Point2D getCenterPoint(Point2D pos, double heading) {
        return new Point2D.Double(pos.getX() - this.halfLength * Math.cos(heading), pos.getY() - this.halfLength * Math.sin(heading));
    }

    public Point2D getPointBetweenFrontWheels(Point2D pos, double heading) {
        return new Point2D.Double(pos.getX() - this.frontAxleDisplacement * Math.cos(heading), pos.getY() - this.frontAxleDisplacement * Math.sin(heading));
    }

    public Point2D[] getCornerPoints(Point2D pos, double heading) {
        Point2D[] result = new Point2D.Double[4];
        double x = pos.getX() + this.halfWidth * Math.cos(heading + 1.5707963267948966);
        double y = pos.getY() + this.halfWidth * Math.sin(heading + 1.5707963267948966);
        result[0] = new Point2D.Double(x, y);
        result[1] = new Point2D.Double(x += this.length * Math.cos(heading + Math.PI), y += this.length * Math.sin(heading + Math.PI));
        x = pos.getX() + this.halfWidth * Math.cos(heading - 1.5707963267948966);
        y = pos.getY() + this.halfWidth * Math.sin(heading - 1.5707963267948966);
        result[3] = new Point2D.Double(x, y);
        result[2] = new Point2D.Double(x += this.length * Math.cos(heading - Math.PI), y += this.length * Math.sin(heading - Math.PI));
        return result;
    }

    public Point2D[] getCornerPoints(double extra, Point2D pos, double heading) {
        Point2D[] result = new Point2D.Double[4];
        double x = pos.getX() + extra / 2.0 * Math.cos(heading) + (this.width + extra) / 2.0 * Math.cos(heading + 1.5707963267948966);
        double y = pos.getY() + extra / 2.0 * Math.sin(heading) + (this.width + extra) / 2.0 * Math.sin(heading + 1.5707963267948966);
        result[0] = new Point2D.Double(x, y);
        result[1] = new Point2D.Double(x += (this.length + extra) * Math.cos(heading + Math.PI), y += (this.length + extra) * Math.sin(heading + Math.PI));
        x = pos.getX() + extra / 2.0 * Math.cos(heading) + (this.width + extra) / 2.0 * Math.cos(heading - 1.5707963267948966);
        y = pos.getY() + extra / 2.0 * Math.sin(heading) + (this.width + extra) / 2.0 * Math.sin(heading - 1.5707963267948966);
        result[3] = new Point2D.Double(x, y);
        result[2] = new Point2D.Double(x += (this.length + extra) * Math.cos(heading - Math.PI), y += (this.length + extra) * Math.sin(heading - Math.PI));
        return result;
    }

    public Point2D getPointBetweenRearWheels(Point2D pos, double heading) {
        return new Point2D.Double(pos.getX() - this.rearAxleDisplacement * Math.cos(heading), pos.getY() - this.rearAxleDisplacement * Math.sin(heading));
    }

    public Point2D getPointBetweenAllWheels(Point2D pos, double heading) {
        double dist = (this.frontAxleDisplacement + this.rearAxleDisplacement) / 2.0;
        return new Point2D.Double(pos.getX() - dist * Math.cos(heading), pos.getY() - dist * Math.sin(heading));
    }

    public Point2D getPointAtRear(Point2D pos, double heading) {
        return new Point2D.Double(pos.getX() - this.length * Math.cos(heading), pos.getY() - this.length * Math.sin(heading));
    }

    public Point2D getPointLeftSideFrontAxle(Point2D pos, double heading) {
        Point2D frontAxle = this.getPointBetweenFrontWheels(pos, heading);
        return new Point2D.Double(frontAxle.getX() + this.halfWidth * Math.cos(heading + 1.5707963267948966), frontAxle.getY() + this.halfWidth * Math.sin(heading + 1.5707963267948966));
    }

    public Point2D getPointRightSideFrontAxle(Point2D pos, double heading) {
        Point2D frontAxle = this.getPointBetweenFrontWheels(pos, heading);
        return new Point2D.Double(frontAxle.getX() + this.halfWidth * Math.cos(heading - 1.5707963267948966), frontAxle.getY() + this.halfWidth * Math.sin(heading - 1.5707963267948966));
    }

    public Point2D getRearLeftCornerPoint(Point2D pos, double heading) {
        double x = pos.getX() + this.halfWidth * Math.cos(heading + 1.5707963267948966);
        double y = pos.getY() + this.halfWidth * Math.sin(heading + 1.5707963267948966);
        return new Point2D.Double(x += this.length * Math.cos(heading + Math.PI), y += this.length * Math.sin(heading + Math.PI));
    }

    public Point2D getRearRightCornerPoint(Point2D pos, double heading) {
        double x = pos.getX() + this.halfWidth * Math.cos(heading - 1.5707963267948966);
        double y = pos.getY() + this.halfWidth * Math.sin(heading - 1.5707963267948966);
        return new Point2D.Double(x += this.length * Math.cos(heading - Math.PI), y += this.length * Math.sin(heading - Math.PI));
    }

    public Point2D[] getWheelCenters(Point2D pos, double heading) {
        Point2D[] result = new Point2D.Double[4];
        Point2D frontAxle = this.getPointBetweenFrontWheels(pos, heading);
        Point2D rearAxle = this.getPointBetweenRearWheels(pos, heading);
        result[0] = new Point2D.Double(frontAxle.getX() + this.wheelSpan * Math.cos(heading + 1.5707963267948966), frontAxle.getY() + this.wheelSpan * Math.sin(heading + 1.5707963267948966));
        result[1] = new Point2D.Double(frontAxle.getX() + this.wheelSpan * Math.cos(heading - 1.5707963267948966), frontAxle.getY() + this.wheelSpan * Math.sin(heading - 1.5707963267948966));
        result[2] = new Point2D.Double(rearAxle.getX() + this.wheelSpan * Math.cos(heading + 1.5707963267948966), rearAxle.getY() + this.wheelSpan * Math.sin(heading + 1.5707963267948966));
        result[3] = new Point2D.Double(rearAxle.getX() + this.wheelSpan * Math.cos(heading - 1.5707963267948966), rearAxle.getY() + this.wheelSpan * Math.sin(heading - 1.5707963267948966));
        return result;
    }

    public Shape[] getWheelShapes(Point2D pos, double heading, double steeringAngle) {
        Shape[] result = new Shape[4];
        Point2D[][] wheelCorners = this.getWheelCorners(pos, heading, steeringAngle);
        for (int tireIdx = 0; tireIdx < 4; ++tireIdx) {
            GeneralPath tire = new GeneralPath();
            tire.moveTo((float)wheelCorners[tireIdx][0].getX(), (float)wheelCorners[tireIdx][0].getY());
            for (int cornerIdx = 1; cornerIdx < 4; ++cornerIdx) {
                tire.lineTo((float)wheelCorners[tireIdx][cornerIdx].getX(), (float)wheelCorners[tireIdx][cornerIdx].getY());
            }
            tire.closePath();
            result[tireIdx] = tire;
        }
        return result;
    }

    private Point2D[][] getWheelCorners(Point2D pos, double heading, double steeringAngle) {
        Point2D[][] result = new Point2D.Double[4][4];
        Point2D[] points = this.getWheelCoords(pos, heading, steeringAngle);
        double halfWheelWidth = this.wheelWidth / 2.0;
        double frontWheelWidthXProjection = halfWheelWidth * Math.cos(heading + steeringAngle + 1.5707963267948966);
        double frontWheelWidthYProjection = halfWheelWidth * Math.sin(heading + steeringAngle + 1.5707963267948966);
        for (int i = 0; i < 4; i += 2) {
            int wheelIdx = i / 2;
            result[wheelIdx][0] = new Point2D.Double(points[i].getX() + frontWheelWidthXProjection, points[i].getY() + frontWheelWidthYProjection);
            result[wheelIdx][1] = new Point2D.Double(points[i].getX() - frontWheelWidthXProjection, points[i].getY() - frontWheelWidthYProjection);
            result[wheelIdx][2] = new Point2D.Double(points[i + 1].getX() - frontWheelWidthXProjection, points[i + 1].getY() - frontWheelWidthYProjection);
            result[wheelIdx][3] = new Point2D.Double(points[i + 1].getX() + frontWheelWidthXProjection, points[i + 1].getY() + frontWheelWidthYProjection);
        }
        double rearWheelWidthXProjection = halfWheelWidth * Math.cos(heading + 1.5707963267948966);
        double rearWheelWidthYProjection = halfWheelWidth * Math.sin(heading + 1.5707963267948966);
        for (int i = 4; i < 8; i += 2) {
            int wheelIdx = i / 2;
            result[wheelIdx][0] = new Point2D.Double(points[i].getX() + rearWheelWidthXProjection, points[i].getY() + rearWheelWidthYProjection);
            result[wheelIdx][1] = new Point2D.Double(points[i].getX() - rearWheelWidthXProjection, points[i].getY() - rearWheelWidthYProjection);
            result[wheelIdx][2] = new Point2D.Double(points[i + 1].getX() - rearWheelWidthXProjection, points[i + 1].getY() - rearWheelWidthYProjection);
            result[wheelIdx][3] = new Point2D.Double(points[i + 1].getX() + rearWheelWidthXProjection, points[i + 1].getY() + rearWheelWidthYProjection);
        }
        return result;
    }

    private Point2D[] getWheelCoords(Point2D pos, double heading, double steeringAngle) {
        Point2D[] result = new Point2D.Double[8];
        Point2D[] wheelCenters = this.getWheelCenters(pos, heading);
        Point2D leftFront = wheelCenters[0];
        Point2D rightFront = wheelCenters[1];
        Point2D leftRear = wheelCenters[2];
        Point2D rightRear = wheelCenters[3];
        double frontXProjection = this.wheelRadius * Math.cos(heading + steeringAngle);
        double frontYProjection = this.wheelRadius * Math.sin(heading + steeringAngle);
        result[0] = new Point2D.Double(leftFront.getX() + frontXProjection, leftFront.getY() + frontYProjection);
        result[1] = new Point2D.Double(leftFront.getX() - frontXProjection, leftFront.getY() - frontYProjection);
        result[2] = new Point2D.Double(rightFront.getX() + frontXProjection, rightFront.getY() + frontYProjection);
        result[3] = new Point2D.Double(rightFront.getX() - frontXProjection, rightFront.getY() - frontYProjection);
        double rearXProjection = this.wheelRadius * Math.cos(heading);
        double rearYProjection = this.wheelRadius * Math.sin(heading);
        result[4] = new Point2D.Double(leftRear.getX() + rearXProjection, leftRear.getY() + rearYProjection);
        result[5] = new Point2D.Double(leftRear.getX() - rearXProjection, leftRear.getY() - rearYProjection);
        result[6] = new Point2D.Double(rightRear.getX() + rearXProjection, rightRear.getY() + rearYProjection);
        result[7] = new Point2D.Double(rightRear.getX() - rearXProjection, rightRear.getY() - rearYProjection);
        return result;
    }
}

