/*
 * Decompiled with CFR 0.152.
 */
package aim4.vehicle;

import aim4.vehicle.VehicleSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VehicleSpecDatabase {
    private static List<VehicleSpec> vehicleSpecs = new ArrayList<VehicleSpec>();
    private static Map<String, Integer> nameToId = new HashMap<String, Integer>();

    public static int getNumOfSpec() {
        return vehicleSpecs.size();
    }

    public static void registerSpec(VehicleSpec spec) {
        assert (!nameToId.containsKey(spec.getName()));
        int id = vehicleSpecs.size();
        nameToId.put(spec.getName(), id);
        vehicleSpecs.add(spec);
    }

    public static boolean replaceSpec(VehicleSpec spec) {
        if (nameToId.containsKey(spec.getName())) {
            int id = nameToId.get(spec.getName());
            VehicleSpec oldSpec = vehicleSpecs.get(id);
            oldSpec.assign(spec);
            return true;
        }
        return false;
    }

    public static int getIdOfVehicleSpec(VehicleSpec spec) {
        Integer id = nameToId.get(spec.getName());
        return id != null ? id : -1;
    }

    public static int getIdByName(String name) {
        Integer id = nameToId.get(name);
        return id != null ? id : -1;
    }

    public static VehicleSpec getVehicleSpecById(int id) {
        return vehicleSpecs.get(id);
    }

    public static VehicleSpec getVehicleSpecByName(String name) {
        Integer id = nameToId.get(name);
        return id != null ? vehicleSpecs.get(id) : null;
    }

    private VehicleSpecDatabase() {
    }

    static {
        VehicleSpecDatabase.registerSpec(new VehicleSpec("COUPE", 4.5, -45.0, 60.0, -17.0, 4.0, 1.75, 1.0, 3.5, 0.75, 0.3, 0.25, 1.0471975511965976, 1.5707963267948966));
        VehicleSpecDatabase.registerSpec(new VehicleSpec("SEDAN", 3.25, -39.0, 55.0, -15.0, 5.0, 1.85, 1.2, 4.0, 0.8, 0.33, 0.25, 1.0471975511965976, 1.0471975511965976));
        VehicleSpecDatabase.registerSpec(new VehicleSpec("SUV", 3.83, -39.0, 52.0, -13.0, 5.131, 2.007, 1.18, 4.126, 0.8385, 0.375, 0.33, 1.0471975511965976, 1.0471975511965976));
        VehicleSpecDatabase.registerSpec(new VehicleSpec("VAN", 3.08, -30.0, 45.0, -10.0, 5.385, 2.014, 0.58, 4.085, 0.8419999999999999, 0.375, 0.33, 1.0471975511965976, 1.0471975511965976));
    }
}

