/*
 * Decompiled with CFR 0.152.
 */
package aim4.vehicle;

import aim4.driver.CrashTestDummy;
import aim4.driver.Driver;
import aim4.im.IntersectionManager;
import aim4.map.lane.Lane;
import aim4.util.GeomMath;
import aim4.util.Util;
import aim4.vehicle.AutoVehicleDriverView;
import aim4.vehicle.BasicAutoVehicle;
import aim4.vehicle.VehicleSimView;
import aim4.vehicle.VehicleSpec;
import java.awt.geom.Area;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VehicleUtil {
    private static final double MIN_MAX_TURN_VELOCITY = 7.0;
    private static final double MAX_TURN_VELOCITY_RESOLUTION = 0.25;
    private static final double SAFE_TRAVERSAL_STEERING_THRESHOLD = 0.4;
    private static final double SAFE_TRAVERSAL_HEADING_THRESHOLD = 0.35;
    private static final double SAFE_TRAVERSAL_STEERING_DELTA = 0.08;
    private static Map<String, Map<List<Integer>, Double>> memoMaxTurnVelocity = new HashMap<String, Map<List<Integer>, Double>>();

    public static double maxTurnVelocity(VehicleSpec spec, Lane arrivalLane, Lane departureLane, IntersectionManager im) {
        if (!memoMaxTurnVelocity.containsKey(spec.getName())) {
            memoMaxTurnVelocity.put(spec.getName(), new HashMap());
        }
        Map<List<Integer>, Double> mmtvs = memoMaxTurnVelocity.get(spec.getName());
        List<Integer> key = Arrays.asList(arrivalLane.getId(), departureLane.getId(), im.getId());
        if (!mmtvs.containsKey(key)) {
            double mtv = VehicleUtil.calculateMaxTurnVelocity(spec, arrivalLane, departureLane, im);
            mmtvs.put(key, mtv);
        }
        return Math.max(mmtvs.get(key), 7.0);
    }

    private static boolean safeToCross(VehicleSpec spec, Lane arrivalLane, Lane departureLane, IntersectionManager im, double traversalVelocity) {
        double simulatedTime;
        if (traversalVelocity <= 0.0 || traversalVelocity > spec.getMaxVelocity()) {
            return false;
        }
        double maxTime = im.traversalDistance(arrivalLane, departureLane) / traversalVelocity;
        BasicAutoVehicle testVehicle = new BasicAutoVehicle(spec, im.getIntersection().getEntryPoint(arrivalLane), im.getIntersection().getEntryHeading(arrivalLane), 0.0, traversalVelocity, 0.0, 0.0, 0.0);
        CrashTestDummy dummy = new CrashTestDummy(testVehicle, arrivalLane, departureLane);
        boolean enteredIntersection = false;
        double minTraversalSteeringAngle = 0.0;
        double maxTraversalSteeringAngle = 0.0;
        for (simulatedTime = 0.0; simulatedTime <= maxTime && (!enteredIntersection || departureLane.getLaneIM().distanceToNextIntersection(testVehicle.getPosition()) == 0.0 || im.getIntersection().getArea().contains(testVehicle.getPosition())); simulatedTime += 0.02) {
            ((Driver)dummy).act();
            if (testVehicle.getSteeringAngle() < minTraversalSteeringAngle) {
                minTraversalSteeringAngle = testVehicle.getSteeringAngle();
            }
            if (testVehicle.getSteeringAngle() > maxTraversalSteeringAngle) {
                maxTraversalSteeringAngle = testVehicle.getSteeringAngle();
            }
            testVehicle.move(0.02);
            if (enteredIntersection || !VehicleUtil.intersects(testVehicle, im.getIntersection().getAreaPlus())) continue;
            enteredIntersection = true;
        }
        if (simulatedTime > maxTime) {
            return false;
        }
        if (-1.0 * minTraversalSteeringAngle > 0.08 && maxTraversalSteeringAngle > 0.08) {
            return false;
        }
        return departureLane.nearestDistance(testVehicle.getPosition()) < (departureLane.getWidth() - testVehicle.getSpec().getWidth()) / 3.0 && Math.abs(testVehicle.getSteeringAngle()) < 0.4 && GeomMath.angleDiff(testVehicle.getHeading(), im.getIntersection().getExitHeading(departureLane)) < 0.35;
    }

    public static double maxVelocityToStopOverDistance(VehicleSpec spec, double distance) {
        return Math.sqrt(-2.0 * spec.getMaxDeceleration() * distance);
    }

    public static double calcDistanceToStop(double startingVelocity, double maxDeceleration) {
        return -1.0 * startingVelocity * startingVelocity / (2.0 * maxDeceleration);
    }

    public static double calcDistanceIfAccel(double startVelocity, double accel, double targetVelocity, double duration) {
        if (accel >= 0.0) {
            if (startVelocity >= targetVelocity) {
                return startVelocity * duration;
            }
            double requestedChange = targetVelocity - startVelocity;
            double maxChange = accel * duration;
            if (requestedChange >= maxChange) {
                return (startVelocity + maxChange / 2.0) * duration;
            }
            double accelDuration = (targetVelocity - startVelocity) / accel;
            double avgAccelVelocity = (targetVelocity + startVelocity) / 2.0;
            return avgAccelVelocity * accelDuration + targetVelocity * (duration - accelDuration);
        }
        if (startVelocity <= targetVelocity) {
            return startVelocity * duration;
        }
        double requestedChange = targetVelocity - startVelocity;
        double maxChange = accel * duration;
        if (requestedChange <= maxChange) {
            return (startVelocity + maxChange / 2.0) * duration;
        }
        double decelDuration = (targetVelocity - startVelocity) / accel;
        double avgDecelVelocity = (targetVelocity + startVelocity) / 2.0;
        return avgDecelVelocity * decelDuration + targetVelocity * (duration - decelDuration);
    }

    public static double timeToChangeBetween(double v0, double vf, double acc) {
        if (Util.isDoubleEqual(v0, vf)) {
            return 0.0;
        }
        if (v0 < vf) {
            if (acc > 0.0) {
                return (vf - v0) / acc;
            }
            return Double.MAX_VALUE;
        }
        if (acc < 0.0) {
            return (vf - v0) / acc;
        }
        return Double.MAX_VALUE;
    }

    public static double timeToChangeBetween(double v0, double vf, double acc, double dec) {
        assert (dec <= 0.0 && acc >= 0.0);
        if (Util.isDoubleEqual(v0, vf)) {
            return 0.0;
        }
        if (v0 < vf) {
            if (Util.isDoubleZero(acc)) {
                return Double.MAX_VALUE;
            }
            return (vf - v0) / acc;
        }
        if (Util.isDoubleZero(dec)) {
            return Double.MAX_VALUE;
        }
        return (vf - v0) / dec;
    }

    public static double distanceToChangeBetween(double v0, double vf, double acc) {
        return VehicleUtil.timeToChangeBetween(v0, vf, acc) * (v0 + vf) / 2.0;
    }

    public static double distanceToChangeBetween(double v0, double vf, double acc, double dec) {
        return VehicleUtil.timeToChangeBetween(v0, vf, acc, dec) * (v0 + vf) / 2.0;
    }

    public static double minimumTimeToCover(double distance, double startVelocity, double topVelocity, double acc) {
        assert (startVelocity < topVelocity);
        double topOutDistance = VehicleUtil.distanceToChangeBetween(startVelocity, topVelocity, acc);
        if (topOutDistance >= distance) {
            return GeomMath.quadraticFormula(acc, 2.0 * startVelocity, -2.0 * distance);
        }
        return VehicleUtil.timeToChangeBetween(startVelocity, topVelocity, acc) + (distance - topOutDistance) / topVelocity;
    }

    private static double calculateMaxTurnVelocity(VehicleSpec spec, Lane arrivalLane, Lane departureLane, IntersectionManager im) {
        double lowerBound = 0.0;
        double upperBound = Math.min(spec.getMaxVelocity(), Math.min(arrivalLane.getSpeedLimit(), departureLane.getSpeedLimit()));
        if (arrivalLane == departureLane) {
            return upperBound;
        }
        while (upperBound - lowerBound > 0.25) {
            double trialVelocity = (upperBound + lowerBound) / 2.0;
            if (VehicleUtil.safeToCross(spec, arrivalLane, departureLane, im, trialVelocity)) {
                lowerBound = trialVelocity;
                continue;
            }
            upperBound = trialVelocity;
        }
        return lowerBound;
    }

    public static boolean intersects(VehicleSimView v, Area area) {
        if (area.contains(v.getPosition()) || area.contains(v.getPointAtRear())) {
            return true;
        }
        Area vehicleArea = new Area(v.getShape());
        vehicleArea.intersect(area);
        return !vehicleArea.isEmpty();
    }

    public static double distanceToCarInFront(AutoVehicleDriverView vehicle) {
        switch (vehicle.getLRFMode()) {
            case DISABLED: {
                return vehicle.getIntervalometer().read();
            }
            case LIMITED: 
            case ENABLED: {
                if (vehicle.isLRFSensing()) {
                    return vehicle.getLRFDistance().read();
                }
                return Double.MAX_VALUE;
            }
        }
        return Double.MAX_VALUE;
    }

    public static boolean collision(VehicleSimView v1, VehicleSimView v2) {
        Area vehicle1Area = new Area(v1.getShape());
        Area vehicle2Area = new Area(v2.getShape());
        vehicle1Area.intersect(vehicle2Area);
        return !vehicle1Area.isEmpty();
    }

    private VehicleUtil() {
    }
}

