; This is an example script to show how to use ACL2 structures.
; Any definitions or lemmas in this file are not used in the actual
; verification. 
(include-book "host-xpspec/structures")

; This is an example data-structure.  Structure s-state has three fields,
; namely pc, regs and mem.  Each field has a type assertion.  For
; instance, the value in the field pc in a well-defined s-structure
; datum must satisfy integerp.  For each field, rewrite rules are
; automatically generated.  One of the rules generated on the field pc
; is 
; (EQUAL (S-STATE-PC (S-STATE PC REGS MEM)) PC) .
; 
(defstructure s-state
  (pc (:assert (integerp pc) :rewrite))
  (regs (:assert (integerp regs) :rewrite))
  (mem (:assert (integerp mem) :rewrite)))

; Prove a very simple lemma as an example. 
(defstub f (x) t) 
(defstub f-pc (x) t) 
(defstub f-mem (x) t) 
(defstub f-regs (x) t) 

(defaxiom s-state-p-f
    (s-state-p (f x)))

(defaxiom s-state-pc-f 
    (equal (s-state-pc (f x))
	   (f-pc x)))

(defaxiom s-state-mem-f 
    (equal (s-state-mem (f x))
	   (f-mem x)))

(defaxiom s-state-regs-f 
    (equal (s-state-regs (f x))
	   (f-regs x)))

(defthm p-state-p-each
 (implies (and (weak-s-state-p y)
	       (equal (f-pc x) (s-state-pc y))
	       (equal (f-regs x) (s-state-regs y))
	       (equal (f-mem x) (s-state-mem y)))
	  (equal (s-state (f-pc x) (f-regs x) (f-mem x)) y)))

(thm (equal (f x) (s-state (f-pc x) (f-regs x) (f-mem x)))
     :hints (("Goal" :restrict ((p-state-p-each (( y (f x))))))))
