(in-package "ACL2")

(include-book "IHS/ihs-absolute-paths")
(include-acl2-book "public/utilities")

(u::import-as-macros
 U::A-UNIQUE-SYMBOL-IN-THE-U-PACKAGE
 defloop)

(defloop non-rec-functions (runes world)
  (for ((rune in runes))
       (unless (fgetprop (cadr rune) 'induction-machine nil world)
	 (collect rune))))

(defloop rec-functions (runes world)
  (for ((rune in runes))
       (when (fgetprop (cadr rune) 'induction-machine nil world)
	 (collect rune))))


(defmacro ww (form)
  "With (W state) ..."
  `(LET ((WORLD (W STATE))) ,form))

;Example
;(ww (non-rec-functions (definition-theory (current-theory :here)) world))

;Example
; (deftheory test (non-rec-functions (theory 'table-def) world))

(defmacro ld-up-to (file event &key (speed '2))
  (let ((skip-proofs-flag (if (equal speed 0) nil
			      (if (equal speed 1) t ''include-book))))
      `(ld ,file :ld-pre-eval-filter ',event :ld-skip-proofsp ,skip-proofs-flag)))

(defmacro refresh (file &key (back-to '1) (up-to ':all) (speed '2))
  (let ((skip-proofs-flag (if (equal speed 0) nil
			      (if (equal speed 1) t ''include-book))))
    `(ld '((ubt! ',back-to) (ld ,file :ld-pre-eval-filter ',up-to
			     :ld-skip-proofsp ,skip-proofs-flag)))))


;;;;;;;
; A computed hint
;;;;;;
; When-found is a macro to supply a computational hint.  When term is
; found in the goal clause, hint is invoked.  An example usage follows:
;  :hints ((when-found (FETCHED-INST MT (MT-FINAL-ISA MT)
;				    (MT-IN-SPECULTV? MT))
;		      (:cases ((b1p (MT-IN-SPECULTV? MT))))))
;
(defmacro when-found (term hint)
  `(and (occur-lst ',term clause) ',hint))

(defun multiple-occur-check (terms)
  (if (endp terms)
      nil
      (if (endp (cdr terms))
	  `(occur-lst ',(car terms) clause)
	  `(and (occur-lst ',(car terms) clause)
		,(multiple-occur-check (cdr terms))))))
		
(defmacro when-found-multiple (terms hint)
  `(and ,(multiple-occur-check terms) ',hint))



(defmacro show-hint (hint &optional marker)
  (cond
   ((and (consp hint)
         (stringp (car hint)))
    hint)
   (t
    `(let ((marker ,marker)
           (ans ,(if (symbolp hint)
                     `(,hint id clause world)
                   hint)))
       (if ans
           (prog2$
            (cw "~%***** Computed Hint~#0~[~/ (from hint ~x1)~]~%~x2~%~%"
                (if (null marker) 0 1)
                marker
                (cons (string-for-tilde-@-clause-id-phrase id)
                      ans))
            ans)
         nil)))))

; do not check if x is a cons.
(defun fmeta-varp (x)
  (and (equal (car x) '@) (symbolp (cadr x))))

(defun fmeta-var-name (x) (cadr x))

(defmacro mv2-or (first second)
  `(mv-let (flg val) ,first
    (if flg (mv flg val) ,second)))

(program)
; restriction on pattern matching. 
;  We don't look into quoted constants.  Quoted constants should be literally
; equal to the pattern or match to a meta-variable as it is.
; Pattern Match returns the substitution for the outer-most matching pattern.
; There may be more than two subterms that match the same pattern.
(mutual-recursion
(defun pattern-match (pattern term subst)
  (cond ((variablep pattern)
	 (if (eq pattern term) (mv t subst) (mv nil nil)))
	((fquotep pattern)
	 (if (equal pattern term) (mv t subst) (mv nil nil)))
	((fmeta-varp pattern)
	 (let ((inst (assoc-eq (fmeta-var-name pattern) subst)))
	   (if inst
	       (if (equal term (cdr inst)) (mv t subst) (mv nil nil))
	       (mv t (cons (cons (fmeta-var-name pattern) term) subst)))))
	((and (not (variablep term))
	      (not (fquotep term))
	      (eq (ffn-symb pattern) (ffn-symb term)))
	 (pattern-match-lst (fargs pattern) (fargs term) subst))
	(t (mv nil nil))))
	 
(defun pattern-match-lst (patterns terms subst)
  (cond ((and (null patterns) (null terms))
	 (mv t subst))
	((or (null patterns) (null terms)) (mv nil nil))
	(t (mv-let (flg new-subst)
		   (pattern-match (car patterns) (car terms) subst)
		   (if flg
		       (pattern-match-lst (cdr patterns) (cdr terms) new-subst)
		       (mv nil nil))))))
)
      

(mutual-recursion
(defun pattern-occur (pattern term)
  (if (or (variablep term) (fquotep term))
      (pattern-match pattern term nil)
      (mv2-or (pattern-match pattern term nil)
	      (pattern-occur-lst pattern (fargs term)))))

(defun pattern-occur-lst (patterns args)
  (cond ((null args) (mv nil nil))
	(t (mv2-or (pattern-occur patterns (car args))
		   (pattern-occur-lst patterns (cdr args))))))
)
    
(mutual-recursion
(defun subst-meta (pattern subst)
  (cond ((or (variablep pattern) (fquotep pattern))
	 pattern)
	((fmeta-varp pattern)
	 (let ((inst (assoc-eq (fmeta-var-name pattern) subst)))
	   (if inst
	       (cdr inst)
	       (prog2$
		(cw "~%****Warning: Meta variable ~x0 not substitued ******~%~%"
		    pattern)
		pattern))))
	(t (cons (ffn-symb pattern) (subst-meta-lst (fargs pattern) subst)))))

(defun subst-meta-lst (patterns subst)
  (if (null patterns)
      nil
      (cons (subst-meta (car patterns) subst)
	    (subst-meta-lst (cdr patterns) subst))))
)
