//
//  ViewController.swift
//  CD-StackViews
//
//  Created by bulko on 10/24/25.
//

import UIKit

class ViewController: UIViewController {

    @IBOutlet weak var label: UILabel!
    @IBOutlet weak var imageView: UIImageView!
    
    let imageCount = 6          // number of images
    var current = 0             // current image
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        showImage(0)
    }
    
    func showImage(_ index:Int) {
        label.text = "Image \(index)"
        imageView.image = UIImage(named: "image\(index)")
    }
    

    @IBAction func onPreviousButtonPressed(_ sender: Any) {
        current = (current + imageCount - 1) % imageCount
        showImage(current)
    }
    
    @IBAction func onResetButtonPressed(_ sender: Any) {
        showImage(0)
        current = 0
    }
    
    @IBAction func onNextButtonPressed(_ sender: Any) {
        current = (current + 1) % imageCount
        showImage(current)
    }
    
    
}

