//
//  ViewController.swift
//  CD-Networking
//
//  Created by bulko on 12/3/25.
//

import UIKit

class ViewController: UIViewController {

    @IBOutlet weak var imageView: UIImageView!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        let imageURL = URL(string: "https://www.cs.utexas.edu/~bulko/images/Kobe.jpg")
        
        // create a session that we can use for this request
        let session = URLSession(configuration: .default)
        
        // create a task for downloading the image>  I could have just
        // used URLSession.shared.datatask, but I used .default just to
        // show you the long way.
        
        let task = session.dataTask(with: imageURL!) { (data, response, error) in
            
            // ensure we did not get an error
            guard error == nil else {
                print("Error fetching data")
                return
            }
            
            // Convert the response to an HTTPURLResponse so we can get
            // a status code
            
            if let httpResponse = response as? HTTPURLResponse {
                
                // ensure we got back a status code of 200 - "Success"
                guard httpResponse.statusCode == 200 else {
                    return
                }
                
                // Make sure we received the data
                if let receivedData = data {
                    
                    // Display the image on the screen.  Since this is
                    // UI stuff, we do it using the main queue
                    
                    DispatchQueue.main.async {
                        self.imageView.image = UIImage(data: receivedData)
                    }
                    
                }
            }
        }
        
        task.resume( )
        
    }


}

