//
//  ViewController.swift
//  CD-Camera
//
//  Created by bulko on 11/5/25.
//

import UIKit
import AVFoundation

class ViewController: UIViewController, UIImagePickerControllerDelegate, UINavigationControllerDelegate {

    @IBOutlet weak var imageView: UIImageView!
    
    let picker = UIImagePickerController()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        picker.delegate = self
    }
    
    func imagePickerController(_ picker: UIImagePickerController, didFinishPickingMediaWithInfo info: [UIImagePickerController.InfoKey : Any]) {
        
        // info contains a DICTIONARY of information about the selected media, including:
        // - metadata
        // - a user-edited image IF the .allowsEditing property is set to True
        
        // get the selected picture:  this is the ONLY part of info we're interested in here
        let chosenImage = info[.originalImage] as! UIImage
        
        // shrink the image to a visible size
        imageView.contentMode = .scaleAspectFit
        
        // put the pic into the imageView
        imageView.image = chosenImage
        
        // dismiss the popover
        dismiss(animated: true)
        
    }
    
    func imagePickerControllerDidCancel(_ picker: UIImagePickerController) {
        print("User decided not to pick an image")
        dismiss(animated: true)
    }
    
    @IBAction func libraryButtonSelected(_ sender: Any) {
        picker.sourceType = .photoLibrary
        picker.allowsEditing = false
        present(picker, animated: true)
    }
    
    @IBAction func cameraButtonSelected(_ sender: Any) {
        
        if UIImagePickerController.availableCaptureModes(for: .rear) != nil {
            // I have a rear camera
            
            switch AVCaptureDevice.authorizationStatus(for: .video) {
            case .notDetermined:
                AVCaptureDevice.requestAccess(for: .video) {
                    accessGranted in
                    guard accessGranted == true else { return }
                }
                break
            case .authorized:
                break
            default:
                print("Access denied")
                return
            }
            
            // this is where all of the "breaks" end up
            
            picker.sourceType = .camera
            picker.allowsEditing = false
            picker.cameraCaptureMode = .photo
            present(picker, animated: true)
            
            
        } else {
            // I don't have a rear camera: pop up an alert
            
            let alertVC = UIAlertController(title: "No camera",
                                            message: "Sorry, this device has no camera",
                                            preferredStyle: .alert)
            let okAction = UIAlertAction(title: "OK", style: .default)
            alertVC.addAction(okAction)
            present(alertVC, animated: true)
            
        }
        
        
        
        
        
        
        
    }
    
    
}

