//
//  ActionSheetExample.swift
//  CD-State
//
//  Created by bulko on 11/19/25.
//

import SwiftUI

struct ActionSheetExample: View {
    
    @State private var showOptions = false
    @State private var selection = "None"
    
    var body: some View {
        VStack {
            
            Button("Click to choose") {
                showOptions = true
            }
            .confirmationDialog("Choose one", isPresented: $showOptions, titleVisibility: .visible) {
                
                Button("Red") {
                    selection = "Red"
                }
                Button("Green") {
                    selection = "Green"
                }
                Button("Blue") {
                    selection = "Blue"
                }
            }
            
            Text(selection)
            
        }
    }
}

#Preview {
    ActionSheetExample()
}
