//
//  AlertExample.swift
//  CD-State
//
//  Created by bulko on 11/19/25.
//

import SwiftUI

struct AlertExample: View {
    
    @State private var showAlert = false
    
    var body: some View {
        
        Button("Show Alert") {
            showAlert = true
        }
        .alert("Important Message", isPresented: $showAlert) {
            Button("Delete", role: .destructive) { }
            Button("Cancel", role: .cancel) { }
            Button("OK") { }
        } message: {
            Text("Please read this")
        }
        
    }
}

#Preview {
    AlertExample()
}
