//
//  PickerExample.swift
//  CD-State
//
//  Created by bulko on 11/17/25.
//

import SwiftUI

struct PickerExample: View {
    
    let colors = ["Red", "Green", "Blue", "Yellow"]
    @State private var selectedColor = "Red"
    
    var body: some View {
        NavigationStack {
            List {
                
                Picker("Choose a Color", selection: $selectedColor) {
                    ForEach(colors, id: \.self) { choice in
                        Text(choice)
                    }
                }
                
                Text("You selected: \(selectedColor)")
                
                NavigationLink(destination: DetailView(selectedColor:$selectedColor)) {
                    Text("Press on me")
                        .frame(minWidth:0, maxWidth: 100)
                        .padding(10)
                        .foregroundStyle(.white)
                        .background(.gray)
                        .cornerRadius(40)
                    
                }
            }
        }
    }
}

#Preview {
    PickerExample()
}
