//
//  ViewController.swift
//  CD-StackViews
//
//  Created by bulko on 7/24/24.
//

import UIKit

class ViewController: UIViewController {

    @IBOutlet weak var label: UILabel!
    @IBOutlet weak var imageView: UIImageView!
    
    let imageCount = 6          // number of images
    var current = 0             // image currently being displayed
    
    override func viewDidLoad() {
        super.viewDidLoad()
        showImage(index: 0)
    }
    
    func showImage(index:Int) {
        label.text = "Image \(index)"
        imageView.image = UIImage(named: "image\(index)")
    }

    @IBAction func onPreviousButtonSelected(_ sender: Any) {
        current = (current + imageCount - 1) % imageCount
        showImage(index: current)
    }
    
    @IBAction func onResetButtonSelected(_ sender: Any) {
        showImage(index: 0)
        current = 0
    }
    
    @IBAction func onNextButtonSelected(_ sender: Any) {
        current = (current + 1) % imageCount
        showImage(index: current)
    }
    
}

