//
//  ViewController.swift
//  CD-Location
//
//  Created by bulko on 7/24/24.
//

import UIKit
import MapKit

class ViewController: UIViewController, MKMapViewDelegate {

    @IBOutlet weak var mapView: MKMapView!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        mapView.delegate = self
        mapView.showsUserLocation = true
        
    }

    @IBAction func zoomIn(_ sender: Any) {
        
        let userLocation = mapView.userLocation
        
        let center = userLocation.location!.coordinate
        let NSdistance = 2000.0  // meters
        let EWdistance = 2000.0  // meters
        
        let region = MKCoordinateRegion(center: center,
                                        latitudinalMeters: NSdistance,
                                        longitudinalMeters: EWdistance)
        
        // "commit" the region
        mapView.setRegion(region, animated: true)
        
    }
    
    @IBAction func changeMapType(_ sender: Any) {
        
        switch mapView.mapType {
        case .standard:
            mapView.mapType = .satellite
        case .satellite:
            mapView.mapType = .hybrid
        case .hybrid:
            mapView.mapType = .standard
        default:
            print("This shouldn't happen!")
        }
        
    }
    
    
}

