//
//  CooperViewController.swift
//  ClassDemo17-Motion
//
//  Created by bulko on 7/26/24.
//  Copyright © 2024 bulko. All rights reserved.
//

import UIKit
import CoreMotion

class CooperViewController: UIViewController {

    @IBOutlet weak var cooperImageView: UIImageView!
    
    let motionManager = CMMotionManager()
    
    override func viewDidLoad() {
        super.viewDidLoad()

        motionManager.deviceMotionUpdateInterval = 0.00000000000001
        
        motionManager.startDeviceMotionUpdates(to: OperationQueue.current!) {
            (deviceMotion, error) in
            if (error == nil) {
                // no error occurred, I can use the data
                
                self.handleDeviceMotionUpdate(deviceMotion:deviceMotion!)
            } else {
                // an error occurred, I should handle it
                print("An error occurred")
            }
        }
    }
    
    func handleDeviceMotionUpdate(deviceMotion:CMDeviceMotion) {
        
        let gravity = deviceMotion.gravity
        let rotation = atan2(gravity.x, gravity.y) - Double.pi
        self.cooperImageView.transform = CGAffineTransform(rotationAngle: rotation)
    }

}
