//
//  ContentView.swift
//  SwiftUIBasics
//
//  Created by bulko on 8/8/25.
//

import SwiftUI

struct ContentView: View {
    var body: some View {
        VStack {
            Button(action: signIn) {
                Text("Button 1")
            }
            .buttonStyle(.bordered)
            Button("Button 2") {
                print("Goodbye")
            }
            .buttonStyle(.borderedProminent)
            Button(action: signIn) {
                Label("Button 3", systemImage: "arrow.up")
            }
            .buttonStyle(.bordered)
            .foregroundStyle(.white)
            .background(Color(.red))
            .clipShape(Capsule())
            Button("Button 4", systemImage: "arrow.up", action: signIn)
        }
    }
}


func signIn() {
    print("Hello")
}


#Preview {
    ContentView()
}

