//
//  Navigation.swift
//  DynamicLists
//
//  Created by bulko on 8/8/25.
//

import SwiftUI

struct Navigation: View {
    var body: some View {
        NavigationStack {
            VStack(spacing: 40) {
                
                NavigationLink(
                    destination: DetailsScreen()) {
                        Text("Press on me")
                    }
                
                Text("Profiles")
                
                NavigationLink(
                    destination: SettingsScreen()) {
                        Text("Settings")
                    }
            }
            .navigationTitle("Main View")
        }
    }
}

struct DetailsScreen: View {
    var body: some View {
        Text("Details Screen")
            .navigationTitle("Details")
    }
}

struct ProfileScreen: View {
    var body: some View {
        Text("Profile Screen")
            .navigationTitle("Profiles")
    }
}

struct SettingsScreen: View {
    var body: some View {
        Text("Settings Screen")
            .navigationTitle("Settings")
    }
}

#Preview {
    Navigation()
}
