//
//  ActionSheet.swift
//  CD-SwiftUIAlerts
//
//  Created by bulko on 7/23/25.
//

import SwiftUI

struct ActionSheet: View {
    
    @State private var showOptions = false
    @State private var selection = "None"
    
    var body: some View {
        
        VStack {
            Button("Click to choose") {
                showOptions = true
            }
            .confirmationDialog("Choose one", isPresented: $showOptions, titleVisibility: .visible) {
                Button("Red") {
                    selection = "Red"
                }
                Button("Green") {
                    selection = "Green"
                }
                Button("Blue") {
                    selection = "Blue"
                }
            }
            
            Text(selection)
            
        }
        
        
        
    }
}

#Preview {
    ActionSheet()
}
