//
//  ContentView.swift
//  CD-SwiftUIAlerts
//
//  Created by bulko on 7/23/25.
//

import SwiftUI

struct ContentView: View {
    
    @State private var showAlert = false
    
    var body: some View {
        Button("Show Alert") {
            showAlert = true
        }
        .alert("Important Messsage", isPresented: $showAlert) {
            Button("Delete", role: .destructive) { }
            Button("Cancel", role: .cancel) { }
            Button("OK") { }
        } message: {
            Text("Please read this")
        }
        
    }
}

#Preview {
    ContentView()
}
