//
//  ListView.swift
//  CD-SwiftUIAlerts
//
//  Created by bulko on 7/23/25.
//

import SwiftUI

struct ListView: View {
    
    @State private var selectedItem: String? = nil
    @State private var showAlert = false
    
    let items = ["Apple", "Banana", "Cherry"]
    
    var body: some View {
        List(items, id: \.self) { item in
            Text(item)
                .onTapGesture {
                    selectedItem = item
                    showAlert = true
                }
        }
        .alert(selectedItem ?? "", isPresented: $showAlert) {
            Button("OK", role: .cancel) { }
        } message: {
            Text("You tapped on \(selectedItem ?? "") ")
        }
    }
}

#Preview {
    ListView()
}
