//
//  TextView.swift
//  CD-SwiftUIAlerts
//
//  Created by bulko on 7/23/25.
//

import SwiftUI

struct TextView: View {
    
    @State private var showAlert = false
    
    var body: some View {
        VStack {
            Text("Show Alert")
                .onTapGesture {
                    showAlert = true
                }
        }
        .alert("Important message", isPresented: $showAlert) {
            Button("Cancel", role: .cancel) { }
            Button("OK") { }
        }
    }
}

#Preview {
    TextView()
}
