//
//  ViewController.swift
//  CD-Calendar
//
//  Created by bulko on 7/25/25.
//

import UIKit
import EventKit

class ViewController: UIViewController {

    @IBOutlet weak var eventTitle: UITextField!
    @IBOutlet weak var startDatePicker: UIDatePicker!
    @IBOutlet weak var endDatePicker: UIDatePicker!
    @IBOutlet weak var statusLabel: UILabel!
    
    var savedEventId: String!
    let eventStore = EKEventStore()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view.
    }
    
    func createEvent() {
        
        let event = EKEvent(eventStore: eventStore)
        
        event.title = eventTitle.text
        event.startDate = startDatePicker.date
        event.endDate = endDatePicker.date
        event.calendar = eventStore.defaultCalendarForNewEvents
        
        do {
            try eventStore.save(event, span: .thisEvent)
            savedEventId = event.eventIdentifier
            postMessage(message: "Event added to calendar")
        } catch {
            postMessage(message: "Event not added due to error")
        }
        
    }

    @IBAction func addEventSelected(_ sender: Any) {
        
        if (EKEventStore.authorizationStatus(for: .event)) != .fullAccess {
            eventStore.requestFullAccessToEvents() {
                (granted,error) in
                if granted {
                    self.createEvent()
                } else {
                    self.postMessage(message: "No calendar access")
                }
            }
        } else {
            // we do already have access
            self.createEvent()
        }
        
    }
    
    func deleteEvent(eventIdentifier: String) {
        
        let eventToRemove = eventStore.event(withIdentifier: eventIdentifier)
        
        if eventToRemove != nil {
            do {
                try eventStore.remove(eventToRemove!, span: .thisEvent)
                postMessage(message: "Event removed from calendar")
            } catch {
                postMessage(message: "Event not removed due to error")
            }
        }
    }
    
    @IBAction func deleteEventSelected(_ sender: Any) {
        
        if (EKEventStore.authorizationStatus(for: .event)) != .fullAccess {
            eventStore.requestFullAccessToEvents() {
                (granted,error) in
                if granted {
                    self.deleteEvent(eventIdentifier: self.savedEventId)
                } else {
                    self.postMessage(message: "No calendar access")
                }
            }
        } else {
            // we do already have access
            self.deleteEvent(eventIdentifier: savedEventId)
        }
        
    }
    
    func postMessage(message: String) {
        DispatchQueue.main.async {
            self.statusLabel.text = message
        }
    }
    
}

