//
//  ViewController.swift
//  ClassDemo8
//
//  Created by bulko on 8/7/25.
//

import UIKit
import AVFoundation

class ViewController: UIViewController, UIImagePickerControllerDelegate, UINavigationControllerDelegate {

    @IBOutlet weak var imageView: UIImageView!
    
    let picker = UIImagePickerController()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        picker.delegate = self
    }

    @IBAction func libraryButtonSelected(_ sender: Any) {
        
        picker.allowsEditing = false
        picker.sourceType = .photoLibrary
        present(picker, animated: true)
        
    }
    
    func imagePickerController(_ picker: UIImagePickerController, didFinishPickingMediaWithInfo info: [UIImagePickerController.InfoKey : Any]) {
        
        // info contains a dictionary of information about the selected media:
        // - metadata
        // - a user-edited image IF the allowsEditing property was set to true
        
        // get the selected picture
        let chosenImage = info[.originalImage] as! UIImage
        
        // make sure the image fits
        imageView.contentMode = .scaleAspectFit
        
        // put the picture into the imageView
        imageView.image = chosenImage
        
        dismiss(animated: true)
    
    }
    
    func imagePickerControllerDidCancel(_ picker: UIImagePickerController) {
        dismiss(animated: true)
    }
    
    @IBAction func cameraButtonSelected(_ sender: Any) {
        
        if UIImagePickerController.availableCaptureModes(for: .rear) != nil {
            
            // We have a rear camera
            
            switch AVCaptureDevice.authorizationStatus(for: .video) {
            case .notDetermined:
                AVCaptureDevice.requestAccess(for: .video) {
                    (granted) in
                    if !granted {
                        return
                    }
                }
            case .authorized:
                break
            default:
                print("Access denied")
                return
            }

            // this is where we end up when we break OR if !granted
            
            picker.allowsEditing = false
            picker.sourceType = .camera
            picker.cameraCaptureMode = .photo
            
            present(picker, animated: true)
            
        } else {
            print("No rear camera")
        }
        
    }
}

