/*
 * commit.h - commit stage interfaces
 *
 * This file is part of the Alpha simulator tool suite written by
 * Raj Desikan as part of the Bullseye project.
 *
 * Copyright (C) 1999 by Raj Desikan
 * This source file is distributed "as is" in the hope that it will be
 * useful.  It is distributed with no warranty, and no author or
 * distributor accepts any responsibility for the consequences of its
 * use. 
 *
 * Everyone is granted permission to copy, modify and redistribute
 * this source file under the following conditions:
 *
 *    This tool set is distributed for non-commercial use only. 
 *    Please contact the maintainer for restrictions applying to 
 *    commercial use of these tools.
 *
 *    Permission is granted to anyone to make or distribute copies
 *    of this source code, either as received or modified, in any
 *    medium, provided that all copyright notices, permission and
 *    nonwarranty notices are preserved, and that the distributor
 *    grants the recipient permission for further redistribution as
 *    permitted by this document.
 *
 *    Permission is granted to distribute this file in compiled
 *    or executable form under the same conditions that apply for
 *    source code, provided that either:
 *
 *    A. it is accompanied by the corresponding machine-readable
 *       source code,
 *    B. it is accompanied by a written offer, with no time limit,
 *       to give anyone a machine-readable copy of the corresponding
 *       source code in return for reimbursement of the cost of
 *       distribution.  This written offer must permit verbatim
 *       duplication by anyone, or
 *    C. it is distributed by someone who received only the
 *       executable form, and is accompanied by a copy of the
 *       written offer of source code that they received concurrently.
 *
 * In other words, you are welcome to use, share and improve this
 * source file.  You are forbidden to forbid anyone else to use, share
 * and improve what you give them.
 *
 */

#ifndef COMMIT_H
#define COMMIT_H
/*
struct store_queue {
  struct fetch_inst_list_template *inst_desc;
  int completed;
  md_addr_t addr;
  union __value {
    quad_t i_result;
    double f_result;
  } value;
  unsigned int tag;
x  int type;
  int valid;
  int tlbmiss;
  int cachemiss;
  int mshrfull;
};
*/
//#define LINE_PRED_INI_VALUE 3
void commit_stage_init(void);
void commit_stage(void);
void commit_flush_pipeline(void);
int valid_sq(struct load_store_queue*, unsigned int);

extern int commit_width;
extern int commit_sq_head;
extern int commit_sq_tail;
extern int commit_sq_num;
extern int commit_sq_nelem;
extern struct load_store_queue *commit_sq;
extern counter_t *num_inst_committed;
extern counter_t commit_ctrl_flushes;
extern counter_t commit_trap_flushes;
extern counter_t cycles_lost;
#endif
   
