/*
 * fetch.h - fetch stage interfaces
 *
 * This file is part of the Alpha simulator tool suite written by
 * Raj Desikan as part of the Bullseye project.
 *
 * Copyright (C) 1999 by Raj Desikan
 *
 * This source file is distributed "as is" in the hope that it will be
 * useful.  It is distributed with no warranty, and no author or
 * distributor accepts any responsibility for the consequences of its
 * use. 
 *
 * Everyone is granted permission to copy, modify and redistribute
 * this source file under the following conditions:
 *
 *    This tool set is distributed for non-commercial use only. 
 *    Please contact the maintainer for restrictions applying to 
 *    commercial use of these tools.
 *
 *    Permission is granted to anyone to make or distribute copies
 *    of this source code, either as received or modified, in any
 *    medium, provided that all copyright notices, permission and
 *    nonwarranty notices are preserved, and that the distributor
 *    grants the recipient permission for further redistribution as
 *    permitted by this document.
 *
 *    Permission is granted to distribute this file in compiled
 *    or executable form under the same conditions that apply for
 *    source code, provided that either:
 *
 *    A. it is accompanied by the corresponding machine-readable
 *       source code,
 *    B. it is accompanied by a written offer, with no time limit,
 *       to give anyone a machine-readable copy of the corresponding
 *       source code in return for reimbursement of the cost of
 *       distribution.  This written offer must permit verbatim
 *       duplication by anyone, or
 *    C. it is distributed by someone who received only the
 *       executable form, and is accompanied by a copy of the
 *       written offer of source code that they received concurrently.
 *
 * In other words, you are welcome to use, share and improve this
 * source file.  You are forbidden to forbid anyone else to use, share
 * and improve what you give them.
 *
 */
#ifndef FETCH_H
#define FETCH_H

/* default size of free list */
#define FETCH_FREE_LIST_SIZE 80 

/*st wait bit masking macro */
#define FETCH_ST_WAIT_BIT(REGS_PC)     (fetch_st_wait_table[(REGS_PC) & fetch_st_wait_mask]); 

/*current PC value*/
extern md_addr_t regs_PC;
/*predicted PC value (declared in bpred.h)*/
extern md_addr_t pred_PC;
/*Line predictor value*/
extern md_addr_t line_pred_PC;

/* define the free list for storing instruction details */
struct fetch_inst_list_template {
  md_inst_t IR;				/* inst register */
  md_addr_t regs_PC, regs_NPC, lpred_PC, bpred_PC;	/* current PC, 
							   next PC, and 
							   predicted PCs */
  enum md_opcode op;                    /* decoded instruction opcode */
  int in_LQ;                            /* non-zero if op is in LQ */
  int in_SQ;                            /* non-zero if op os in SQ */
  int dest_reg;                         /* whether dest reg is int or fp*/
  int src_reg1;                          /* whether src regs are int or fp */
  int src_reg2;
  int clus_assigned;  /*Cluster number assigned to this entry for execution */
  int sub_cluster_assigned;             /* subcluster assigned to this instruction */
  unsigned int inum;                    /* inum assigned to this instruction */
  int reg_type[2];                      /* Input Arch register types */
  int in_arch_regs[2];                  /* Input Arch regs */
  int out_arch_reg;			/* output Arch reg */
  int in_phy_regs[2];                   /* Input Physical regs mapped */
  int out_phy_reg;			/* Output physical regs mapped*/
  enum sub_cluster_type slot_clus_assigned;		/* cluster assigned statically by slot */
  enum sub_cluster_required sub_clus_req;   /* Subcluster(s) on which this instruction can execute */
  int r_buf_no;                         /* reorder buffer entry number. For squashing instructions on a mispredict */
  int lq_no;                            /* load queue no. */
  int sq_no;                            /* store queue no. */
  int iflag;                            /* Instruction flag for traps */
  int cmov;                             /* Set to true in case the conditional 
					   move is not performed (weird) */
  int trap;                             /* set if the instruction traps */
  int stack_recover_idx;
  int double_prec;                      /* set to true if instruction is 
					   double precision */
  int pred_set;                        /* Line predictor cache set */
  int pred_blk_no;                     /* Line predictor blk number */
  int pred_offset;                     /* Line predictor inst offset */
  counter_t st_wait_bit;               /* st wait bit for this instruction */
  counter_t time_stamp;               /* Cycle this instruction was fetched */ 
  int local_pred;                      /* Local prediction for this inst */
  int global_pred;                     /* Global prediction for this inst */
  int choice_pred;                     /* Choice prediction for this inst */
  int load_trap_penalty;               /* penalty of current load trap */
  int fpstore;                         /* TRUE if instruction is a fp store */
  struct fetch_inst_list_template * next;
};

/*FETCH -> SLOT instruction queue definition*/
struct fetch_queue {
  struct fetch_inst_list_template *inst_desc;
  struct bpred_update_t dir_update;
};

/* Structure for buffering information about stalled i-fetches */
struct _istall_buf {
  int stall;
  int resume;
  md_inst_t inst;
};

/* list of externs */
extern int fetch_ifq_size;
extern int fetch_num;
extern int fetch_head; 
extern int fetch_tail;
extern struct fetch_queue *fetch_data;
extern struct _istall_buf fetch_istall_buf;
extern int fetch_set; /* holds set of cache line accessed */
extern int fetch_blk_no; /* Holds blk no */
extern int fetch_inst_offset; /* Holds offset */
extern int fetch_way_pred; /* Way prediction */
extern int fetch_way_pred_set; /* Way predictor set */
extern int fetch_way_pred_blk_no; /* Way predictor blk no */
extern int fetch_way_pred_offset; /* Way predictor offset */
extern int fetch_width;
extern int line_predictor;
extern int fetch_speed;
extern md_addr_t fetch_pred_PC;
extern counter_t *num_inst_fetched;
extern counter_t *fetch_st_wait_table;
extern int fetch_st_table_size;
extern int fetch_st_wait_mask; 
extern int line_pred_width;


/* function prototypes */
void fetch_stage_init(void);
void fetch_stage(void);
void fetch_init_inst_free_list(void);
struct fetch_inst_list_template* fetch_get_from_free_list(void);
void fetch_return_to_free_list(struct fetch_inst_list_template *);
void schedule_resume_ifetch(tick_t);
void fetch_resume_ifetch(tick_t, int);
void schedule_tlb_resume_ifetch(tick_t, cache_access_packet*, MSHR_STAMP_TYPE);

#endif
