/*
 * issue.h- issue stage interfaces
 *
 * This file is part of the Alpha simulator tool suite written by
 * Raj Desikan as part of the Bullseye project.
 *
 * Copyright (C) 1999 by Raj Desikan
 *
 * This source file is distributed "as is" in the hope that it will be
 * useful.  It is distributed with no warranty, and no author or
 * distributor accepts any responsibility for the consequences of its
 * use. 
 *
 * Everyone is granted permission to copy, modify and redistribute
 * this source file under the following conditions:
 *
 *    This tool set is distributed for non-commercial use only. 
 *    Please contact the maintainer for restrictions applying to 
 *    commercial use of these tools.
 *
 *    Permission is granted to anyone to make or distribute copies
 *    of this source code, either as received or modified, in any
 *    medium, provided that all copyright notices, permission and
 *    nonwarranty notices are preserved, and that the distributor
 *    grants the recipient permission for further redistribution as
 *    permitted by this document.
 *
 *    Permission is granted to distribute this file in compiled
 *    or executable form under the same conditions that apply for
 *    source code, provided that either:
 *
 *    A. it is accompanied by the corresponding machine-readable
 *       source code,
 *    B. it is accompanied by a written offer, with no time limit,
 *       to give anyone a machine-readable copy of the corresponding
 *       source code in return for reimbursement of the cost of
 *       distribution.  This written offer must permit verbatim
 *       duplication by anyone, or
 *    C. it is distributed by someone who received only the
 *       executable form, and is accompanied by a copy of the
 *       written offer of source code that they received concurrently.
 *
 * In other words, you are welcome to use, share and improve this
 * source file.  You are forbidden to forbid anyone else to use, share
 * and improve what you give them.
 *
 */
#ifndef ISSUE_H
#define ISSUE_H

#define ISSUE_HOLD 1			/* Number of cycles an inst is 
					   held in the issue Q after
					   it is issued */
#define NOTREADY 0
#define READY 1
#define NOMATCH 0
#define MATCH 1
#define NOTALLOWED 0
#define ALLOWED 1
#define COMBO00 0
#define COMBO01 1
#define COMBO10 2
#define COMBO11 3
#define MAX_DELAY 1  /* Maximum cross cluster delay */
#define ISSUE_QUEUE_MAX_SIZE 1000

/* non-zero if event is a valid (non-squashed) entry */
#define EVENT_VALID(EVENT)	((EVENT)->inum == (EVENT)->qelem->inst_desc->inum)

/* free an event queue entry */
#define EVENT_FREE(LINK)						\
  {  struct rqueue_link *r_link = (LINK);				\
     r_link->inum = DNA;   			\
     r_link->next = event_queue_free_list;				\
     event_queue_free_list = r_link;					\
  }

typedef unsigned int INST_SEQ_TYPE;

enum sub_cluster_required {
  LOWER01 = 0,
  LOWER0,
  LOWER1,
  UPPER01,
  UPPER0,
  UPPER1,
  UPPERLOWER
};

/* integer/fp issue queue template */
struct queue_elem {
  struct fetch_inst_list_template *inst_desc;
  int op_ready[2];			/* If both fields are one, 
					   means ops are ready */
  int op_clusters[2];			/* clusters writing the 
					   operands */
  int op_delay[2];			/* Holds the delay for the 
					   two operands */
  int func_ready;			/* if 1, func unit is ready */
  int issued;				
  int retire_cycle;				/* cycle this entry will be 
					           removed from the issue Q */
  int clus_assigned; /* Cluster number assigned to this entry for execution */
  int valid;         /* if this entry is valid. Checked by writeback stage
			to see if this entry can be put in the ready queue */
  int completed;     /* set when instruction completes execution */
  int blocked;
  int st_wait_bit;  /* If true means the st wait bit is set for this 
		       instruction */
  int cmov; /* If true means there is a cmov dependence */
  tick_t issue_cycle; /* Cycle this instruction was put in the issue queue */
  tick_t optime[2]; /* Cycle when operands were ready */
  int clus[4];
};

struct issue_window {
  struct queue_elem *window;  /* Entry in the queue */
  int queue_pointer;  /* Pointer to the top of queue */
  int queue_nelem;  /* Total number of elements in the queue */
  int queue_num;  /* Number of elements at present in the queue */
};

/* The ready queue structure */
struct rqueue_link {
  struct queue_elem *qelem;		/* referenced Q entry */
  int inum;
  int queued;
  struct rqueue_link *next;	/* next entry in the list */
  union {
    tick_t when;		/* time stamp of entry (for eventq) */
    INST_SEQ_TYPE seq;                  /* inst sequence */
    int opnum;			/* input/output operand number */
  } x;
};

/* Load queue structure */

struct load_store_queue {
  struct fetch_inst_list_template *inst_desc;
  int completed;
  md_addr_t addr;
  struct __value {
    quad_t i_result;
    /* BUGFIX AJ - LSQ FWDING */
    quad_t f_result;
  /* BUGFIX */
  } value;
  /* BUGFIX 09/08/2003 - Start */
  unsigned long tag;
  /* BUGFIX 09/08/2003 - End */
  int type;
  int valid;
  int tlbmiss;
  int cachemiss;
  int mshrfull;
  int size; /* Size of operand to be loaded or stored */
  /* BUGFIX 04/24/2004 - Start */
  /* Aamer Jaleel              */
  /* <ajaleel@umd.edu>         */
  int stqhit;
  unsigned long stqhitinum;
  tick_t exec_cycle;
  /* BUGFIX 04/24/2004 - End   */
};


extern int issue_num_of_queues;
extern struct issue_window *IQ;
extern struct issue_window *FQ;
extern int issue_int_width;
extern int issue_fp_width;

/* function declarations */
void issue_stage_init(void);
void issue_stage(void);
void issue_int_readyq_enqueue(struct rqueue_link *);
void issue_fp_readyq_enqueue(struct rqueue_link *);
struct rqueue_link * get_free_ready_node(struct rqueue_link *);
struct rqueue_link * get_free_event_node(struct rqueue_link *);
void init_readyq_free_list(void);
void init_eventq_free_list(void);
void readyq_return_to_free_list(struct rqueue_link *);
void queue_event(struct rqueue_link *, tick_t);
struct queue_elem * issue_next_event(void);
void issue_int_dec(tick_t, int);
void issue_fp_dec(tick_t, int);

extern struct rqueue_link *int_ready_queue;  /* integer ready queue */
extern struct rqueue_link *fp_ready_queue;   /* fp ready queue */
extern struct rqueue_link *ready_queue_free_list;
extern struct rqueue_link *event_queue_free_list;
extern struct rqueue_link *event_queue;
extern int issue_lq_head;
extern int issue_lq_tail;
extern int issue_lq_nelem;
extern int issue_lq_num;
extern struct load_store_queue *issue_lq;
extern counter_t *num_int_inst_issued;
extern counter_t *num_fp_inst_issued;
extern int int_reg_read_latency;
extern int fp_reg_read_latency;
extern int full_bypass;
int int_bypass_allowed;
int fp_bypass_allowed;
extern int issue_no_slot_clus;
#endif
