/*
 * map.h - map stage interfaces
 *
 * This file is part of the Alpha simulator tool suite written by
 * Raj Desikan as part of the Bullseye project.
 * It has been written by extending the SimpleScalar tool suite written by
 * Todd M. Austin as a part of the Multiscalar Research Project.
 *  
 * 
 * Copyright (C) 1994, 1995, 1996, 1997, 1998 by Todd M. Austin
 *
 * Copyright (C) 1999 by Raj Desikan
 *
 * This source file is distributed "as is" in the hope that it will be
 * useful.  It is distributed with no warranty, and no author or
 * distributor accepts any responsibility for the consequences of its
 * use. 
 *
 * Everyone is granted permission to copy, modify and redistribute
 * this source file under the following conditions:
 *
 *    This tool set is distributed for non-commercial use only. 
 *    Please contact the maintainer for restrictions applying to 
 *    commercial use of these tools.
 *
 *    Permission is granted to anyone to make or distribute copies
 *    of this source code, either as received or modified, in any
 *    medium, provided that all copyright notices, permission and
 *    nonwarranty notices are preserved, and that the distributor
 *    grants the recipient permission for further redistribution as
 *    permitted by this document.
 *
 *    Permission is granted to distribute this file in compiled
 *    or executable form under the same conditions that apply for
 *    source code, provided that either:
 *
 *    A. it is accompanied by the corresponding machine-readable
 *       source code,
 *    B. it is accompanied by a written offer, with no time limit,
 *       to give anyone a machine-readable copy of the corresponding
 *       source code in return for reimbursement of the cost of
 *       distribution.  This written offer must permit verbatim
 *       duplication by anyone, or
 *    C. it is distributed by someone who received only the
 *       executable form, and is accompanied by a copy of the
 *       written offer of source code that they received concurrently.
 *
 * In other words, you are welcome to use, share and improve this
 * source file.  You are forbidden to forbid anyone else to use, share
 * and improve what you give them.
 *
 * INTERNET: raju@cs.utexas.edu
 * US Mail:  8200B W. Gate Blvd, Austin, TX 78745
 */
#ifndef MAP_H
#define MAP_H

/* define the dependency chain size */
#define DEP_CHAIN_SIZE 20

#define OP1 1
#define OP2 2
#define STWAIT 3
#define CMOV_BIT 4

#define ST_WAIT_CLR  16384     /* St wait bits cleared after 16384 cycles */
/* Define maximum inum number */
/* The formula used to compute this is n^2 + n(n-1)/2, where n is the reorder
   buffer number. MAX_INUM should be at least greater than this.
   We are assuming reorder buffer of size 10k. Change this 
   variable if the size of reorder buffer becomes more */

#define MAX_INUM 200000000

/* define the dependency chain */
struct dep_chain {
  struct queue_elem *qelem;		/* pointer to entry in the 
					   issue queue */
  struct fetch_inst_list_template *inst_desc;
  struct dep_chain *next;		/* pointer to next dependency */
};

/* define the reorder buffer */

struct reorder_buffer {
  struct fetch_inst_list_template *inst_desc;
  struct dep_chain *op1_deps;	/* instructions whose 1st 
					   operand depends on this rb 
					   entry. contains the issue 
					   Q entry number */
  struct dep_chain *op2_deps;	/* instructions whose 2nd 
					   operand depends on this rb 
					   entry. contains the issue 
					   Q entry number */
  struct dep_chain *stdeps;     /* instructions whose st wait bit has been 
				   set, and hence depend on this inst. */
  struct dep_chain *cmovdeps; /* instructions on whichcmov insts depend */
  int completed;
  int mispredict;
  int replaytrap;
  md_addr_t correctPC;          /* Stores the correct PC on a mispredict */
  struct bpred_update_t dir_update;
  int in_LQ; /* set if inst is in load queue */
  int in_SQ; /* set if inst is in store queue */
};

/* Structure for storing map info */
struct int_reg_mapping {
  int phy_reg;			/* physical register mapped */
  int rbuf_no;			/* reorder buffer entry mapping this */
};

extern int map_rb_nelem;
extern int map_width;
extern int map_rb_head;
extern int map_rb_tail;
extern int map_rb_num;
extern struct reorder_buffer *map_rb;
extern struct int_reg_mapping map_ir_mapping[MD_I_ARCH_REGS+1];
extern struct int_reg_mapping map_fr_mapping[MD_F_ARCH_REGS];
extern counter_t *num_inst_mapped;
extern counter_t map_num_early_retire;
extern int map_int_issue_size;
extern int map_fp_issue_size;
extern int free_int_reg_list_head; 
extern int free_fp_reg_list_head;
extern int free_int_reg_list_tail;
extern int free_fp_reg_list_tail;
extern int *free_int_reg_list;
extern int *free_fp_reg_list;
extern int num_of_free_int_regs;
extern int num_of_free_fp_regs;
extern int early_inst_retire;
extern int map_stall;

extern counter_t stat_int_reg_reads;
extern counter_t stat_int_reg_writes;
extern counter_t stat_fp_reg_reads;
extern counter_t stat_fp_reg_writes;

/* LSQ reads */
extern counter_t stat_lq_reads;
extern counter_t stat_sq_reads;
extern counter_t stat_lq_writes;
extern counter_t stat_sq_writes;

void map_stage_init(void); 
void map_stage(void);
int get_free_int_reg(void);
int get_free_fp_reg(void);
void map_put_free_int_reg(int);
void map_put_free_fp_reg(int);
struct dep_chain* get_from_free_list();
void init_free_list();
void return_to_free_list(struct dep_chain *);
void add_prod_link(int, struct queue_elem *, int);
#endif

