/*
 * slot.h - slot stage interfaces
 *
 * This file is part of the Alpha simulator tool suite written by
 * Raj Desikan as part of the Bullseye project.
 * It has been written by extending the SimpleScalar tool suite written by
 * Todd M. Austin as a part of the Multiscalar Research Project.
 *  
 * 
 * Copyright (C) 1994, 1995, 1996, 1997, 1998 by Todd M. Austin
 *
 * Copyright (C) 1999 by Raj Desikan
 *
 * This source file is distributed "as is" in the hope that it will be
 * useful.  The tool set comes with no warranty, and no author or
 * distributor accepts any responsibility for the consequences of its
 * use. 
 * 
 * Everyone is granted permission to copy, modify and redistribute
 * this tool set under the following conditions:
 * 
 *    This source code is distributed for non-commercial use only. 
 *    Please contact the maintainer for restrictions applying to 
 *    commercial use.
 *
 *    Permission is granted to anyone to make or distribute copies
 *    of this source code, either as received or modified, in any
 *    medium, provided that all copyright notices, permission and
 *    nonwarranty notices are preserved, and that the distributor
 *    grants the recipient permission for further redistribution as
 *    permitted by this document.
 *
 *    Permission is granted to distribute this file in compiled
 *    or executable form under the same conditions that apply for
 *    source code, provided that either:
 *
 *    A. it is accompanied by the corresponding machine-readable
 *       source code,
 *    B. it is accompanied by a written offer, with no time limit,
 *       to give anyone a machine-readable copy of the corresponding
 *       source code in return for reimbursement of the cost of
 *       distribution.  This written offer must permit verbatim
 *       duplication by anyone, or
 *    C. it is distributed by someone who received only the
 *       executable form, and is accompanied by a copy of the
 *       written offer of source code that they received concurrently.
 *
 * In other words, you are welcome to use, share and improve this
 * source file.  You are forbidden to forbid anyone else to use, share
 * and improve what you give them.
 *
 *
 *
 */


#ifndef SLOT_H
#define SLOT_H

struct slot_latch {
  struct fetch_inst_list_template *inst_desc;
  struct bpred_update_t dir_update;
};

/*The different slot classes */
enum alpha_slot_class {
  ULUL=0,
  ULLU,
  UULL,
  LLUU,
  ULLL,
  LULU,
  LUUL,
  LLLL,
  LLLU,
  LULL,
  LUUU,
  LLUL,
  ULUU,
  UULU,
  UUUL,
  UUUU,
  SLOT_CLASS_INVALID
};

/* Returns the subcluster in which the current instruction can
  execute. The value is shifted depending on the number of the inst. 
  slotted, and the bits required to encode slotting of instruction */
#define SLOT_SUB_CLUS_REQ(OP_CODE,I)					\
	slot_sub_clus_req(OP_CODE) << (I * slot_clus_bits)

/* Returns slot class for the given inst class */
#define SLOT_INSCLASS_SLOTCLASS(INST_MIX, SLOT_ALGO)  			\
	slot_instclass2slotclass[SLOT_ALGO][INST_MIX]


/* list of externs */
extern struct slot_latch *SL;
extern int slot_latch_head;
extern int slot_latch_tail;
extern int slot_latch_num;
extern int slot_clus_bits;
extern int slot_algo;
extern int target_compute;
extern int slot_width;
extern counter_t *num_inst_slotted;
extern int last_branch;
extern int line_pred_ini_value;
extern int line_pred_spec_update;
extern int slot_adder;
extern int static_slotting;


/* function prototypes */
void slot_stage_init(void);

void slot_stage(void);


#endif




