/*
 * writeback.h - writeback stage interfaces
 *
 * This file is part of the Alpha simulator tool suite written by
 * Raj Desikan as part of the Bullseye project.
 * Copyright (C) 1999 by Raj Desikan
 *
 * This source file is distributed "as is" in the hope that it will be
 * useful.  It is distributed with no warranty, and no author or
 * distributor accepts any responsibility for the consequences of its
 * use. 
 *
 * Everyone is granted permission to copy, modify and redistribute
 * this source file under the following conditions:
 *
 *    This tool set is distributed for non-commercial use only. 
 *    Please contact the maintainer for restrictions applying to 
 *    commercial use of these tools.
 *
 *    Permission is granted to anyone to make or distribute copies
 *    of this source code, either as received or modified, in any
 *    medium, provided that all copyright notices, permission and
 *    nonwarranty notices are preserved, and that the distributor
 *    grants the recipient permission for further redistribution as
 *    permitted by this document.
 *
 *    Permission is granted to distribute this file in compiled
 *    or executable form under the same conditions that apply for
 *    source code, provided that either:
 *
 *    A. it is accompanied by the corresponding machine-readable
 *       source code,
 *    B. it is accompanied by a written offer, with no time limit,
 *       to give anyone a machine-readable copy of the corresponding
 *       source code in return for reimbursement of the cost of
 *       distribution.  This written offer must permit verbatim
 *       duplication by anyone, or
 *    C. it is distributed by someone who received only the
 *       executable form, and is accompanied by a copy of the
 *       written offer of source code that they received concurrently.
 *
 * In other words, you are welcome to use, share and improve this
 * source file.  You are forbidden to forbid anyone else to use, share
 * and improve what you give them.
 *
 *
 */

#ifndef WRITEBACK_H
#define WRITEBACK_H


#define DNA (-1)
#define CPC regs.regs_PC
#define CPC regs.regs_PC
#define DUNIQ (32)
#define UNIQ (regs.regs_C.uniq)
#define DFPCR (0+32+32)
#define FPCR (regs.regs_C.fpcr)
#define DGPR(N) (N)
#define GPR_D(N) ((N) &~1)
//#define GPR(N) (regs.regs_R[(N)])
//#define SET_GPR(N,EXPR) (regs.regs_R[(N)]=(EXPR))

#define GPR(N) (regs.regs_R[map_ir_mapping[(N)].phy_reg])
#define SET_GPR(N,EXPR) ((elem->inst_desc->out_phy_reg != DNA) ? (regs.regs_R[elem->inst_desc->out_phy_reg] = (EXPR)):(regs.regs_R[31] = 0))
#define spec_mem_access mem_access
/* precise architected memory state accessor macros, NOTE: speculative copy on
   write storage provided for fast recovery during wrong path execute (see
   tracer_recover() for details on this process */
#define __READ_SPECMEM(SRC, SRC_V)				\
  (addr = (SRC),						\
   (spec_mode							\
    ?   spec_mem_access(Read, addr, &SRC_V, sizeof(SRC_V))      \
    :  mem_access(Read, addr, &SRC_V, sizeof(SRC_V))),	        \
   SRC_V)

#define READ_BYTE(SRC, FAULT)   \
  ((FAULT) = md_fault_none, __READ_SPECMEM((SRC), temp_byte))
#define READ_HALF(SRC, FAULT)   \
  ((FAULT) = md_fault_none, __READ_SPECMEM((SRC), temp_half))
#define READ_WORD(SRC, FAULT)   \
  ((FAULT) = md_fault_none, __READ_SPECMEM((SRC), temp_word))
#ifdef HOST_HAS_QUAD
#define READ_QUAD(SRC, FAULT)   \
  ((FAULT) = md_fault_none, __READ_SPECMEM((SRC), temp_quad))
#endif /* HOST_HAS_QUAD */

#define __WRITE_SPECMEM(DST, SRC, DST_V)				\
  (DST_V = (SRC), addr = (DST),						\
   (spec_mode								\
    ? ( spec_mem_access(Write, addr, &DST_V, sizeof(DST_V)))\
    : ( mem_access(Write, addr, &DST_V, sizeof(DST_V)))))

#define WRITE_BYTE(SRC, DST, FAULT)     \
  ((FAULT) = md_fault_none, __WRITE_SPECMEM((DST), (SRC), temp_byte))
#define WRITE_HALF(SRC, DST, FAULT)     \
  ((FAULT) = md_fault_none, __WRITE_SPECMEM((DST), (SRC), temp_half))
#define WRITE_WORD(SRC, DST, FAULT)     \
  ((FAULT) = md_fault_none, __WRITE_SPECMEM((DST), (SRC), temp_word))
#ifdef HOST_HAS_QUAD
#define WRITE_QUAD(SRC, DST, FAULT)     \
  ((FAULT) = md_fault_none, __WRITE_SPECMEM((DST), (SRC), temp_quad))
#endif /* HOST_HAS_QUAD */

#define SET_FPR_Q(N,EXPR) (regs.regs_F.q[elem->inst_desc->out_phy_reg]=(EXPR))
// (regs.regs_F.d[elem->inst_desc->out_phy_reg] = (EXPR))
#define DFPR_L(N)               (((N)+33)&~1)
#define DFPR_F(N)               (((N)+33)&~1)
#define DFPR_D(N)               (((N)+33)&~1)
   //#define DFPR(N)                 (((N) == 31) ? DNA : ((N)+33))
#define DFPR(N)                 ((N)+33)
#define FPR_Q(N) (regs.regs_F.q[map_fr_mapping[(N)].phy_reg])
#define SET_NPC(EXPR)           (regs.regs_NPC = (EXPR))
#define FPR(N) (regs.regs_F.d[map_fr_mapping[(N)].phy_reg])
#define SYSCALL(INST) sys_syscall(&regs, mem_access, INST, TRUE)
#define ZERO_FP_REG()   regs.regs_F.d[MD_REG_ZERO] = 0.0
#define SET_UNIQ(EXPR) regs.regs_C.uniq = EXPR
#define SET_FPR(N,EXPR) (regs.regs_F.d[elem->inst_desc->out_phy_reg]=(EXPR))
   //            (regs.regs_F.q[elem->inst_desc->out_phy_reg]=(EXPR))
#define SET_FPCR(EXPR) (regs.regs_C.fpcr=(EXPR))
#define FPR_L(N)		(regs.regs_F.l[map_fr_mapping[(N)].phy_reg])
#define SET_FPR_L(N,EXPR)	(regs.regs_f.l[elem->inst_desc->out_phy_reg] = (EXPR))
#define FPR_F(N)		(regs.regs_F.f[map_fr_mapping[(N)].phy_reg])
#define SET_FPR_F(N,EXPR)	(regs.regs_F.f[elem->inst_desc->out_phy_reg] = (EXPR))
#define FPR_D(N)		(regs.regs_F.d[map_fr_mapping[(N)].phy_reg >> 1])
#define SET_FPR_D(N,EXPR)	(regs.regs_F.d[elem->inst_desc->out_phy_reg >> 1] = (EXPR))

/* miscellaneous
 register accessors */
#define SET_HI(EXPR)		(regs.regs_C.hi = (EXPR))
#define HI			(regs.regs_C.hi)
#define SET_LO(EXPR)		(regs.regs_C.lo = (EXPR))
#define LO			(regs.regs_C.lo)
#define FCC			(regs.regs_C.fcc)
#define SET_FCC(EXPR)		(regs.regs_C.fcc = (EXPR))
   //#define SET_TPC (void)0
#define UNIQ (regs.regs_C.uniq) 
#define DFPCR (0+32+32)
#define FPCR (regs.regs_C.fpcr)
#define DGPR(N) (N)
#define GPR_D(N) ((N) &~1)
#define DFPR_L(N)               (((N)+33)&~1)
#define DFPR_F(N)               (((N)+33)&~1)
#define DFPR_D(N)               (((N)+33)&~1)
   //#define DFPR(N)                 (((N) == 31) ? DNA : ((N)+33))
#define DFPR(N)                ((N)+33)
#define SET_NPC(EXPR)           (regs.regs_NPC = (EXPR))
#define ZERO_FP_REG()   regs.regs_F.d[MD_REG_ZERO] = 0.0

#define OPERANDS_READY(EV)                                               \
  ((EV)->op_ready[0] && (EV)->op_ready[1] && (EV)->st_wait_bit == FALSE && (EV)->cmov == FALSE)

/* Makethe correct macro for address calculation */

#define CALC_ADDR(OP,ADDRESS,VALUE)     OP##_ADDR(ADDRESS,VALUE)

#define LQ 1
#define SQ 2
void writeback_stage_init(void);
void writeback_stage(void);
void writeback_exec_loadstore(tick_t, int, int);
void writeback_wakeup(tick_t, int);
/* BUGFIX 09/08/2003 - Start */
int valid_lq(struct load_store_queue*, unsigned long);
/* BUGFIX 09/08/2003 - End */
extern counter_t wb_load_replaytrap;
extern counter_t wb_store_replaytrap;
extern counter_t wb_diffsize_replaytrap;
/* BUGFIX 04/24/2004 - Start */
/* Aamer Jaleel              */
/* <ajaleel@umd.edu>         */
extern counter_t wb_lsq_data_fwd;
/* BUGFIX 04/24/2004 - End   */
extern int wb_load_use_speculation;
extern int load_replay_trap;
extern int diffsize_trap;

extern counter_t wb_trap_cycles_lost;
#endif
   
