
#=======================================================================#
# Required packages and source files:
#
package require Tk 8.0

global MYHOME

set bench_path $env(BENCHMARK_PATH)
set bindex [string last / $bench_path]
set bench_file [string range $bench_path $bindex end]
set bench_file [string trimleft $bench_file /]
set bench_file [string toupper $bench_file]
set bindex [string first . $bench_file]
set bench_file [string range $bench_file 0 [expr $bindex - 1]]

# source "$env(VISUAL_SOURCE_DIR)/balloon.tcl"
source "ui/balloon.tcl"
source "ui/colors.tcl"
source "ui/menubar.tcl"
source "ui/stat.tcl"
source "ui/status.tcl"
source "ui/stepbar.tcl"
source "ui/stepper.tcl"
source "ui/system.tcl"
source "ui/graphs.tcl"
source "ui/helpmesg.tcl"
source "ui/popup.tcl"
source "ui/thumbnail.tcl"
source "ui/window.tcl"


# Get SimpleScalar interface package
# (stubs version if not available):
#
source "ui/ss_interface.tcl"

#-----------------------------------------------------------------------#
# Global options and main window startup:
#
set ss_version 3.0
set engine_version 1.2

set title "SimpleScalar Visualizer"
# append title " v${engine_version}"
# append title " (Ss v${ss_version})"

set MYHOME "$env(HOME)"
set BASE_DIR "$env(BASE_DIR)"
set APP_NAME "$env(APP_NAME)"
set BENCHMARK_PATH "$env(BENCHMARK_PATH)"
set COMESFROM_PATH "$env(COMESFROM_PATH)"
set OPTIONS "$env(OPTIONS)"
set OUTPUT_PATH "$env(OUTPUT_PATH)"

wm title    . $title
wm iconname . "SimpleScalar Visualizer"
# wm iconbitmap . /local/cartel/ss-viz/app-defaults/ssv.bm
# wm iconmask . /local/cartel/ss-viz/app-defaults/ssv_msk.bm
wm protocol . WM_DELETE_WINDOW "prompt_close ."

#-----------------------------------------------------------------------#
# Define and position first-level widgets:
#  * .status	Activity monitor, plus error message display.
#  * .menubar	Buttons for options setting menus, etc.;
#  * .stepbar	Buttons for stepping simulator, plus cycle display;
#  * .system	Canvas for drawing memory and execution units;
#
#  * .balloon	Special top-level widget for showing balloon help.
#  * .helpmesg  Special top-level wodget for showing help on buttons.
#
#  * init_graph TK procedure that initializes all the graph parameters.
#
# Build ".status" first, since the other parts use it.
#
status_create  .status
balloon_create .balloon
menubar_create .menubar
stepbar_create .stepbar
system_create  .system
help_message_create .helpmesg
init_graph
init_thumbnail
init_popup

pack .menubar -fill x -side top
pack .stepbar -fill x -side top
pack .status  -fill x -side bottom

pack .system  -expand yes -fill both

bind . <Control-r> {system_display .system}

set current [ss::getStatistic "sim_cycle"]
stepfield_next .stepbar collect $current
stepfield_next .stepbar display $current

#-----------------------------------------------------------------------#
# Top-level bindings:
#
bind . <Control-c> {menubar_exit .status}
bind . <Unmap> {hide_toplevels}
bind . <Map> {show_toplevels}

#-----------------------------------------------------------------------#
# Initialize from external sources (files, libraries, interfaces):
#
stat_init ::allStatistics ::allCycles

unitset_reader "default.ssv" -system

system_display .system

#-----------------------------------------------------------------------#
# End of initialization.  All actions should now be hooked to buttons.
#
# status_message .status "Initialization complete (Ss v${ss_version})"
status_message .status "Benchmark ${bench_file} is loaded.  Press an arrow button to begin."


