#include "eval.h"
#include "host.h"
#include "options.h"
#include "sim.h"
#include <stddef.h>
/* need to undef panic because it has its own use in tcl.h */
#undef panic
#include <tcl.h>
#include "tcl_ss.h"
#include <strings.h>

extern
struct opt_odb_t *sim_odb ;

extern
struct stat_sdb_t *sim_sdb ;

 
Tcl_Obj *
optNewElementObj (struct opt_opt_t *opt, int index)
{
    if (NULL != opt) {
	switch (opt->oc) {

	case oc_int:
	    return Tcl_NewIntObj (opt->variant.for_int.var[index]) ;

	case oc_uint:
	    return Tcl_NewLongObj ((long) opt->variant.for_uint.var[index]) ;

	case oc_float:
	    return Tcl_NewDoubleObj
		((double) opt->variant.for_float.var[index]) ;

	case oc_double:
	    return Tcl_NewDoubleObj (opt->variant.for_double.var[index]) ;

	case oc_enum: {
	    char *estr = NULL ;
	    int n ;
	    int val = opt->variant.for_enum.var[index] ;

	    for (n = 0 ; n < opt->variant.for_enum.emap_sz ; ++n)
		if (val == opt->variant.for_enum.eval[n])
		    estr = opt->variant.for_enum.emap[n] ;
	    return Tcl_NewStringObj (estr ? estr : "", -1) ;
	}

	case oc_flag:
	    return Tcl_NewBooleanObj (opt->variant.for_enum.var[index]) ;

	case oc_string: {
	    char *str = opt->variant.for_string.var[index] ;
	    return Tcl_NewStringObj ( (str ? str : "") , -1 ) ;
	}

	default :
	    break ;
	}
    }

    return Tcl_NewStringObj ("", -1) ;
}

int
optMakeValueList (Tcl_Interp *interp, Tcl_Obj *value, struct opt_opt_t *opt)
{
    Tcl_Obj *element = NULL ;
    int status = TCL_OK ;

    if (NULL == value) {
	Tcl_Obj *result = Tcl_GetObjResult (interp) ;
	Tcl_SetStringObj (result, "bad Tcl_Obj* in optMakeValueList",-1) ;
	return TCL_ERROR ;
    }

    if (NULL == opt) {
	Tcl_Obj *result = Tcl_GetObjResult (interp) ;
	Tcl_SetStringObj (result, "bad opt_opt_t* in optMakeValueList",-1);
	return TCL_ERROR ;
    }

    if (! opt->nelt) {
	element = optNewElementObj (opt, 0) ;
	status = Tcl_ListObjAppendElement (interp, value, element) ;
    } else {
	int n ;
	for (n = 0 ; TCL_OK == status && n < *opt->nelt ; ++n) {
	    element = optNewElementObj (opt, n) ;
	    status = Tcl_ListObjAppendElement (interp, value, element) ;
	}
    }

    if (TCL_OK != status) {
	Tcl_Obj *ret = Tcl_GetObjResult (interp) ;
	Tcl_SetStringObj (ret, "option value structure error", -1) ;
	return TCL_ERROR ;
    }

    return TCL_OK ;
}

int
optMakeEntryList (Tcl_Interp *interp, Tcl_Obj *entry, struct opt_opt_t *opt)
{
    Tcl_Obj *item = NULL ;
    Tcl_Obj *temp = NULL ;

    if (NULL == entry) {
	Tcl_Obj *result = Tcl_GetObjResult (interp) ;
	Tcl_SetStringObj (result, "bad Tcl_Obj* in optMakeEntryList",-1) ;
	return TCL_ERROR ;
    }

    if (NULL == opt) {
	Tcl_Obj *result = Tcl_GetObjResult (interp) ;
	Tcl_SetStringObj (result, "bad opt_opt_t* in optMakeEntryList",-1);
	return TCL_ERROR ;
    }

    /*
     * Start new entry with option name:
     */
    item = Tcl_NewStringObj (opt->name, -1) ;
    if (TCL_OK != Tcl_ListObjAppendElement (interp, entry, item))
	return TCL_ERROR ;

    /*
     * Append pair containing description:
     */
    item = Tcl_NewListObj (0, NULL) ;
    temp = Tcl_NewStringObj ("-description", -1) ;
    if (TCL_OK != Tcl_ListObjAppendElement (interp, item, temp))
	return TCL_ERROR ;
    temp = Tcl_NewStringObj (opt->desc, -1) ;
    if (TCL_OK != Tcl_ListObjAppendElement (interp, item, temp))
	return TCL_ERROR ;
    if (TCL_OK != Tcl_ListObjAppendElement (interp, entry, item))
	return TCL_ERROR ;

    /*
     * Append pair with print format:
     */
    item = Tcl_NewListObj (0, NULL) ;
    temp = Tcl_NewStringObj ("-format", -1) ;
    if (TCL_OK != Tcl_ListObjAppendElement (interp, item, temp))
	return TCL_ERROR ;
    temp = Tcl_NewStringObj (opt->format, -1) ;
    if (TCL_OK != Tcl_ListObjAppendElement (interp, item, temp))
	return TCL_ERROR ;
    if (TCL_OK != Tcl_ListObjAppendElement (interp, entry, item))
	return TCL_ERROR ;

    /*
     * Append pair specifying whether it's a list of values:
     */
    item = Tcl_NewListObj (0, NULL) ;
    temp = Tcl_NewStringObj ("-list", -1) ;
    if (TCL_OK != Tcl_ListObjAppendElement (interp, item, temp))
	return TCL_ERROR ;
    temp = Tcl_NewBooleanObj (1 != opt->nvars) ;
    if (TCL_OK != Tcl_ListObjAppendElement (interp, item, temp))
	return TCL_ERROR ;
    if (TCL_OK != Tcl_ListObjAppendElement (interp, entry, item))
	return TCL_ERROR ;

    /*
     * Append pair specifying value type:
     */
    item = Tcl_NewListObj (0, NULL) ;
    temp = Tcl_NewStringObj ("-type", -1) ;
    if (TCL_OK != Tcl_ListObjAppendElement (interp, item, temp))
	return TCL_ERROR ;

    switch (opt->oc) {
    case oc_int:	temp = Tcl_NewStringObj("int",-1) ;	break ;
    case oc_uint:	temp = Tcl_NewStringObj("unsigned",-1); break ;
    case oc_float:	temp = Tcl_NewStringObj("float",-1) ;	break ;
    case oc_double:	temp = Tcl_NewStringObj("double",-1) ;	break ;
    case oc_enum:	temp = Tcl_NewStringObj("enum",-1) ;	break ;
    case oc_flag:	temp = Tcl_NewStringObj("flag",-1) ;	break ;
    case oc_string:	temp = Tcl_NewStringObj("string",-1) ;	break ;
    default :		temp = Tcl_NewStringObj("?",-1) ;	break ;
    }

    if (TCL_OK != Tcl_ListObjAppendElement (interp, item, temp))
	return TCL_ERROR ;
    if (TCL_OK != Tcl_ListObjAppendElement (interp, entry, item))
	return TCL_ERROR ;

    /*
     * Append pair containing value:
     */
    item = Tcl_NewListObj (0, NULL) ;
    temp = Tcl_NewStringObj ("-value", -1) ;
    if (TCL_OK != Tcl_ListObjAppendElement (interp, item, temp))
	return TCL_ERROR ;
    temp = Tcl_NewListObj (0, NULL) ;
    if (TCL_OK != optMakeValueList (interp, temp, opt))
	return TCL_ERROR ;
    if (TCL_OK != Tcl_ListObjAppendElement (interp, item, temp))
	return TCL_ERROR ;
    if (TCL_OK != Tcl_ListObjAppendElement (interp, entry, item))
	return TCL_ERROR ;

    return TCL_OK ;
}

Tcl_Obj *
statNewElementObj (struct stat_stat_t *stat, int index)
{
    if (NULL != stat) {
	/* stat_print_stat(sim_sdb,stat,stderr); */
	switch (stat->sc)
	{
	case sc_int:
	    return Tcl_NewIntObj (*stat->variant.for_int.var) ;

	case sc_uint:
	    return Tcl_NewLongObj ((long)*stat->variant.for_uint.var) ;

#ifdef HOST_HAS_QWORD

	case sc_qword:
	    return Tcl_NewDoubleObj ((double)*stat->variant.for_qword.var);

	case sc_sqword:
	    return Tcl_NewDoubleObj ((double)*stat->variant.for_sqword.var);

#endif /* HOST_HAS_QWORD */

	case sc_float:
	    return Tcl_NewDoubleObj ((double)*stat->variant.for_float.var);

	case sc_double:
	    return Tcl_NewDoubleObj (*stat->variant.for_double.var);
	case sc_formula: 
	{
	    struct eval_state_t *es = eval_new (stat_eval_ident, sim_sdb);
	    char *endp;
	    struct eval_value_t val =
		eval_expr (es, stat->variant.for_formula.formula, &endp) ;

	    if (eval_error == ERR_NOERR && *endp == '\0') {
		Tcl_Obj *result = Tcl_NewDoubleObj (eval_as_double(val)) ;
		eval_delete (es);
		return result ;
	    }

	    eval_delete (es) ;
	}   break ;
	default:
	    break ;
	}
    }

    return Tcl_NewStringObj ("", -1) ;
}

int
statMakeValueList(Tcl_Interp *interp,Tcl_Obj *value,struct stat_stat_t *stat)
{
    Tcl_Obj *element = NULL ;

    if (NULL == value) {
	Tcl_Obj *result = Tcl_GetObjResult (interp) ;
	Tcl_SetStringObj (result, "bad Tcl_Obj* in statMakeValueList",-1) ;
	return TCL_ERROR ;
    }

    if (NULL == stat) {
	Tcl_Obj *result = Tcl_GetObjResult (interp) ;
	Tcl_SetStringObj (result, "bad stat_stat_t* in statMakeValueList",-1);
	return TCL_ERROR ;
    }

    element = statNewElementObj (stat, 0) ;

    if (TCL_OK != Tcl_ListObjAppendElement (interp, value, element)) {
	Tcl_Obj *ret = Tcl_GetObjResult (interp) ;
	Tcl_SetStringObj (ret, "statistic value structure error", -1) ;
	return TCL_ERROR ;
    }

    return TCL_OK ;
}

int
statMakeEntryList(Tcl_Interp *interp,Tcl_Obj *entry,struct stat_stat_t *stat)
{
    Tcl_Obj *item = NULL ;
    Tcl_Obj *temp = NULL ;

    if (NULL == entry) {
	Tcl_Obj *result = Tcl_GetObjResult (interp) ;
	Tcl_SetStringObj (result, "bad Tcl_Obj* in statMakeEntryList", -1);
	return TCL_ERROR ;
    }

    if (NULL == stat) {
	Tcl_Obj *result = Tcl_GetObjResult (interp) ;
	Tcl_SetStringObj (result, "bad stat_stat_t* in statMakeEntryList", -1);
	return TCL_ERROR ;
    }

    /*
     * Start new entry list with statistic name:
     */
    item = Tcl_NewStringObj (stat->name, -1) ;
    if (TCL_OK != Tcl_ListObjAppendElement (interp, entry, item))
	return TCL_ERROR ;

    /*
     * Append pair containing description:
     */
    item = Tcl_NewListObj (0, NULL) ;
    temp = Tcl_NewStringObj ("-description", -1) ;
    if (TCL_OK != Tcl_ListObjAppendElement (interp, item, temp))
	return TCL_ERROR ;
    temp = Tcl_NewStringObj (stat->desc, -1) ;
    if (TCL_OK != Tcl_ListObjAppendElement (interp, item, temp))
	return TCL_ERROR ;
    if (TCL_OK != Tcl_ListObjAppendElement (interp, entry, item))
	return TCL_ERROR ;

    /*
     * Append pair with print format:
     */
    item = Tcl_NewListObj (0, NULL) ;
    temp = Tcl_NewStringObj ("-format", -1) ;
    if (TCL_OK != Tcl_ListObjAppendElement (interp, item, temp))
	return TCL_ERROR ;
    temp = Tcl_NewStringObj (stat->format, -1) ;
    if (TCL_OK != Tcl_ListObjAppendElement (interp, item, temp))
	return TCL_ERROR ;
    if (TCL_OK != Tcl_ListObjAppendElement (interp, entry, item))
	return TCL_ERROR ;

    /*
     * Append pair specifying value type:
     */
    item = Tcl_NewListObj (0, NULL) ;
    temp = Tcl_NewStringObj ("-type", -1) ;
    if (TCL_OK != Tcl_ListObjAppendElement (interp, item, temp))
	return TCL_ERROR ;

    switch (stat->sc) {
    case sc_int:	temp = Tcl_NewStringObj("int",-1) ;	break ;
    case sc_uint:	temp = Tcl_NewStringObj("unsigned",-1); break ;
    case sc_float:	temp = Tcl_NewStringObj("float",-1) ;	break ;
    case sc_double:	temp = Tcl_NewStringObj("double",-1) ;	break ;

#ifdef HOST_HAS_QWORD

    case sc_qword:	temp = Tcl_NewStringObj("qword",-1) ;	break ;
    case sc_sqword:	temp = Tcl_NewStringObj("sqword",-1) ;	break ;

#endif /* HOST_HAS_QWORD */

    case sc_formula:
	temp = Tcl_NewStringObj ("formula", -1) ;
	if (TCL_OK != Tcl_ListObjAppendElement (interp, item, temp))
	    return TCL_ERROR ;
	temp = Tcl_NewStringObj (stat->variant.for_formula.formula, -1) ;
	break ;
    default :		temp = Tcl_NewStringObj("?",-1) ;	break ;
    }

    if (TCL_OK != Tcl_ListObjAppendElement (interp, item, temp))
	return TCL_ERROR ;
    if (TCL_OK != Tcl_ListObjAppendElement (interp, entry, item))
	return TCL_ERROR ;

    /*
     * Append pair containing value:
     */
    item = Tcl_NewListObj (0, NULL) ;
    temp = Tcl_NewStringObj ("-value", -1) ;
    if (TCL_OK != Tcl_ListObjAppendElement (interp, item, temp))
	return TCL_ERROR ;
    temp = Tcl_NewListObj (0, NULL) ;
    if (TCL_OK != statMakeValueList (interp, temp, stat))
	return TCL_ERROR ;
    if (TCL_OK != Tcl_ListObjAppendElement (interp, item, temp))
	return TCL_ERROR ;
    if (TCL_OK != Tcl_ListObjAppendElement (interp, entry, item))
	return TCL_ERROR ;

    return TCL_OK ;
}

int
Ss_CmdGetOption
(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[])
{
    char *optName = NULL ;
    struct opt_opt_t *opt = NULL ;
    Tcl_Obj *result = NULL ;

    if (objc != 2) {
	Tcl_WrongNumArgs (interp, 1, objv, "option_name") ;
	return TCL_ERROR ;
    }

    if (NULL == (optName = Tcl_GetStringFromObj (objv[1], NULL))) {
	Tcl_SetResult (interp, "null option name", TCL_STATIC) ;
	return TCL_ERROR ;
    }	

    if (NULL == (opt = opt_find_option(sim_odb,optName))) {
	result = Tcl_GetObjResult (interp) ;
	Tcl_SetStringObj (result, "bad option name ", -1) ;
	Tcl_AppendToObj (result, optName, -1) ;
	return TCL_ERROR ;
    }

    /* result = Tcl_GetObjResult (interp) ; */
    result = Tcl_NewListObj (0, NULL) ;
    if (TCL_OK != optMakeValueList (interp, result, opt))
	return TCL_ERROR ;
    Tcl_SetObjResult (interp, result) ;

    return TCL_OK ;
}

int
Ss_CmdGetStatistic
(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[])
{
    char *statName = NULL ;
    struct stat_stat_t *stat = NULL ;
    Tcl_Obj *result = NULL ;

    if (objc != 2) {
	Tcl_WrongNumArgs (interp, 1, objv, "statistic_name") ;
	return TCL_ERROR ;
    }

    if (NULL == (statName = Tcl_GetStringFromObj (objv[1], (int *) NULL))) {
	Tcl_SetResult (interp, "null statistic name", TCL_STATIC) ;
	return TCL_ERROR ;
    }	

    if (NULL == (stat = stat_find_stat (sim_sdb, statName))) {
	result = Tcl_GetObjResult (interp) ;
	Tcl_SetStringObj (result, "Sorry: bad statistics name ", -1) ;
	Tcl_AppendToObj (result, statName, -1) ;
	return TCL_ERROR ;
    }
  /*  printf("name:value=%s:%s\n", statName, stat); */
  /* 
  fprintf(stderr, "=================\n");
  fprintf(stderr, "Value for %s:\n", statName);
  stat_print_stat(sim_sdb,stat,stderr);
  fprintf(stderr, "-----------------\n");
  */
    result = statNewElementObj (stat, 0) ;

    Tcl_SetObjResult (interp, result) ;

    return TCL_OK ;
}

int
Ss_CmdIsOption
(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[])
{
    char *optName = NULL ;
    struct opt_opt_t *opt = NULL ;

    if (objc != 2) {
	Tcl_WrongNumArgs (interp, 1, objv, "option_name") ;
	return TCL_ERROR ;
    }

    if (NULL == (optName = Tcl_GetStringFromObj (objv[1], (int *) NULL))) {
	Tcl_SetResult (interp, "null option name", TCL_STATIC) ;
	return TCL_ERROR ;
    }	

    opt = opt_find_option (sim_odb, optName) ;

    Tcl_SetObjResult ( interp , Tcl_NewBooleanObj (NULL != opt) ) ;

    return TCL_OK ;
}

int
Ss_CmdIsStatistic
(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[])
{
    char *statName = NULL ;
    struct stat_stat_t *stat = NULL ;

    if (objc != 2) {
	Tcl_WrongNumArgs (interp, 1, objv, "statistic_name") ;
	return TCL_ERROR ;
    }

    if (NULL == (statName = Tcl_GetStringFromObj (objv[1], (int *) NULL))) {
	Tcl_SetResult (interp, "null statistic name", TCL_STATIC) ;
	return TCL_ERROR ;
    }	

    stat = stat_find_stat (sim_sdb, statName) ;

    Tcl_SetObjResult ( interp , Tcl_NewBooleanObj (NULL!=stat) ) ;

    return TCL_OK ;
}

int
Ss_CmdListOption
(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[])
{
    struct opt_opt_t *opt ;
    Tcl_Obj *result ;

    if (objc != 1) {
	Tcl_WrongNumArgs (interp, 1, objv, "") ;
	return TCL_ERROR ;
    }

    result = Tcl_NewListObj (0, objv) ;

    if (NULL != sim_odb) {
	for (opt = sim_odb->options ; NULL != opt ; ) {
	    Tcl_Obj *entry = Tcl_NewListObj (0, objv) ;
	    if (TCL_OK != optMakeEntryList (interp, entry, opt))
		return TCL_ERROR ;
	    if (TCL_OK != Tcl_ListObjAppendElement (interp, result, entry))
		return TCL_ERROR ;
	    opt = opt->next ;
	}
    }

    Tcl_SetObjResult (interp, result) ;

    return TCL_OK ;
}

int
Ss_CmdListStatistic
(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[])
{
    Tcl_Obj *result ;
    struct stat_stat_t *stat ;

    if (objc != 1) {
	Tcl_WrongNumArgs (interp, 1, objv, "") ;
	return TCL_ERROR ;
    }

    result = Tcl_NewListObj (0, objv) ;

    if (NULL != sim_sdb) {
	for (stat = sim_sdb->stats ; NULL != stat ; ) {
	    Tcl_Obj *entry = Tcl_NewListObj (0, objv) ;
	    if (TCL_OK != statMakeEntryList (interp, entry, stat))
		return TCL_ERROR ;
	    if (TCL_OK != Tcl_ListObjAppendElement (interp, result, entry))
		return TCL_ERROR ;
	    stat = stat->next ;
	}
    }

    Tcl_SetObjResult (interp, result) ;

    return TCL_OK ;
}

int
Ss_CmdSetStatistic
(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[])
{
    Tcl_Obj *result ;

    if (objc != 3) {
	Tcl_WrongNumArgs (interp, 1, objv, "statistic_name value") ;
	return TCL_ERROR ;
    }

    result = Tcl_GetObjResult (interp) ;
    Tcl_SetStringObj (result, "not yet implemented!", -1) ;
    return TCL_ERROR ;
}

int
Ss_CmdStep
(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[])
{
    long numsteps ;
    Tcl_Obj *result ;

    if (objc != 2) {
	Tcl_WrongNumArgs (interp, 1, objv, "step_count") ;
	return TCL_ERROR ;
    }

    result = Tcl_GetObjResult (interp) ;

    if (Tcl_GetLongFromObj (interp, objv[1], &numsteps) != TCL_OK) {
	Tcl_SetStringObj (result, "step count should be integer", -1) ;
	return TCL_ERROR ;
    }

    Tcl_SetLongObj (result, sim_step(numsteps)) ;

    return TCL_OK ;
}

int
Ss_CmdGetIFQItems
(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[])
{
  Tcl_Obj *result;
  char String[2000];

  (void)bzero(String, 2000);
  if(objc != 1) {
    Tcl_WrongNumArgs(interp,1,objv,"<IFQBozo>");
    return TCL_ERROR;
  }
  result = Tcl_GetObjResult(interp);
  /* 
  if(Tcl_GetIntFromObj(interp,objv[1],&IFQSlot) != TCL_OK) {
    Tcl_SetStringObj(result,"IFQ slot number should be an integer",-1);
    return TCL_ERROR;
  }
  */
  NewGetInstDataFromIFQ(String);

  Tcl_SetStringObj(result,String,-1);

  return TCL_OK;
}

int
Ss_CmdGetIFQItem
(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[])
{
  /*  OBSOLETE
  Tcl_Obj *result;
  int IFQSlot;
  char String[200];

  if(objc != 2) {
    Tcl_WrongNumArgs(interp,1,objv,"<IFQSlot>");
    return TCL_ERROR;
  }

  result = Tcl_GetObjResult(interp);

  if(Tcl_GetIntFromObj(interp,objv[1],&IFQSlot) != TCL_OK) {
    Tcl_SetStringObj(result,"IFQ slot number should be an integer",-1);
    return TCL_ERROR;
  }

  GetInstDataFromIFQ(IFQSlot,String);

  Tcl_SetStringObj(result,String,-1);
  */

  return TCL_OK;
}

int
Ss_CmdGetRUUItems
(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[])
{
  Tcl_Obj *result;
  int RUUSlot;
  char String[2000];
  (void)bzero(String, 2000);

  if(objc != 2) {
    Tcl_WrongNumArgs(interp,1,objv,"<RUUSlot>");
    return TCL_ERROR;
  }

  result = Tcl_GetObjResult(interp);

  if(Tcl_GetIntFromObj(interp,objv[1],&RUUSlot) != TCL_OK) {
    Tcl_SetStringObj(result,"RUU slot number should be an integer",-1);
    return TCL_ERROR;
  }

  GetInstDataFromRUU(RUUSlot,String);

  Tcl_SetStringObj(result,String,-1);

  return TCL_OK;
}

int
Ss_CmdGetFUItems
(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[])
{
  Tcl_Obj *result;
  int FUSlot;
  char String[2000];
  (void)bzero(String, 2000);

  if(objc != 2) {
    Tcl_WrongNumArgs(interp,1,objv,"<FUSlot>");
    return TCL_ERROR;
  }

  result = Tcl_GetObjResult(interp);

  if(Tcl_GetIntFromObj(interp,objv[1],&FUSlot) != TCL_OK) {
    Tcl_SetStringObj(result,"FU slot number should be an integer",-1);
    return TCL_ERROR;
  }

  GetInstDataFromFU(FUSlot,String);

  Tcl_SetStringObj(result,String,-1);

  return TCL_OK;
}

int
Ss_CmdGetLSQItems
(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[])
{
  Tcl_Obj *result;
  int LSQSlot;
  char String[2000];
  (void)bzero(String, 2000);

  if(objc != 2) {
    Tcl_WrongNumArgs(interp,1,objv,"<LSQSlot>");
    return TCL_ERROR;
  }

  result = Tcl_GetObjResult(interp);

  if(Tcl_GetIntFromObj(interp,objv[1],&LSQSlot) != TCL_OK) {
    Tcl_SetStringObj(result,"LSQ slot number should be an integer",-1);
    return TCL_ERROR;
  }

  GetInstDataFromLSQ(LSQSlot,String);

  Tcl_SetStringObj(result,String,-1);

  return TCL_OK;
}

int
Ss_Init (Tcl_Interp *interp)
{
    int i;
    /*
     * ::ss::getOption <string>
     */
    Tcl_CreateObjCommand(
	interp,
	"::ss::getOption",
	Ss_CmdGetOption,
	(ClientData) NULL,
	(Tcl_CmdDeleteProc *) NULL
	) ;

    /*
     * ::ss::getStatistic <string>
     */
    Tcl_CreateObjCommand(
	interp,
	"::ss::getStatistic",
	Ss_CmdGetStatistic,
	(ClientData) NULL,
	(Tcl_CmdDeleteProc *) NULL
	) ;

    /*
     * ::ss::isOption <string>
     */
    Tcl_CreateObjCommand(
	interp,
	"::ss::isOption",
	Ss_CmdIsOption,
	(ClientData) NULL,
	(Tcl_CmdDeleteProc *) NULL
	) ;

    /*
     * ::ss::isStatistic <string>
     */
    Tcl_CreateObjCommand(
	interp,
	"::ss::isStatistic",
	Ss_CmdIsStatistic,
	(ClientData) NULL,
	(Tcl_CmdDeleteProc *) NULL
	) ;

    /*
     * ::ss::listOption
     */
    Tcl_CreateObjCommand(
	interp,
	"::ss::listOption",
	Ss_CmdListOption,
	(ClientData) NULL,
	(Tcl_CmdDeleteProc *) NULL
	) ;

    /*
     * ::ss::listOption
     */
    Tcl_CreateObjCommand(
	interp,
	"::ss::listStatistic",
	Ss_CmdListStatistic,
	(ClientData) NULL,
	(Tcl_CmdDeleteProc *) NULL
	) ;

    /*
     * ::ss::setStatistic <string> <value>
     */
    Tcl_CreateObjCommand(
	interp,
	"::ss::setStatistic",
	Ss_CmdSetStatistic,
	(ClientData) NULL,
	(Tcl_CmdDeleteProc *) NULL
	) ;

    /*
     * ::ss::step <int>
     */
    Tcl_CreateObjCommand(
	interp,
	"::ss::step",
	Ss_CmdStep,
	(ClientData) NULL,
	(Tcl_CmdDeleteProc *) NULL
	) ;

    /*
      ::ss::getIFQItem & Ss_CmdGetIFQItem <int> returns all the
      instruction data corresponding to that IFQ slot with index <int>
    */

        Tcl_CreateObjCommand(
        interp,
	"::ss::getIFQItem",
	Ss_CmdGetIFQItem,
	(ClientData) NULL,
	(Tcl_CmdDeleteProc *) NULL
	) ;

    /*
      ::ss::getIFQItems & Ss_CmdGetIFQItems return all the
      instruction data corresponding to the IFQ 
    */
        Tcl_CreateObjCommand(
        interp,
	"::ss::getIFQItems",
	Ss_CmdGetIFQItems,
	(ClientData) NULL,
	(Tcl_CmdDeleteProc *) NULL
	) ;
    /*
      ::ss::getRUUItems & Ss_CmdGetRUUItems <int> return all the
      instruction data from the RUU
    */
        Tcl_CreateObjCommand(
        interp,
	"::ss::getRUUItems",
	Ss_CmdGetRUUItems,
	(ClientData) NULL,
	(Tcl_CmdDeleteProc *) NULL
	) ;
    /*
      ::ss::getLSQItems & Ss_CmdGetLSQItems return all the
      instruction data from the LSQ
    */
        Tcl_CreateObjCommand(
        interp,
	"::ss::getLSQItems",
	Ss_CmdGetLSQItems,
	(ClientData) NULL,
	(Tcl_CmdDeleteProc *) NULL
	) ;
    /*
      ::ss::getFUItems & Ss_CmdGetFUItems <int> return all the
      instruction data from the FU, whatever its configuration
    */
        Tcl_CreateObjCommand(
        interp,
	"::ss::getFUItems",
	Ss_CmdGetFUItems,
	(ClientData) NULL,
	(Tcl_CmdDeleteProc *) NULL
	) ;
    i= (int)(Tcl_PkgProvide (interp, "Ss", "1.2")) ;
    /* printf ("Init code: %d.\n", i); */
    /* 
    fprintf(stderr, "Initial database values:\n");
    stat_print_stats(sim_sdb,stderr);
    fprintf(stderr, "=================\n");
    */
    return TCL_OK ;
}
