##################################################################
# colors.tcl
#
# Used to set global colors and fonts
##################################################################
set wholeApplicationBackground LightSkyBlue1
set wholeApplicationFont "-*-Helvetica-Bold-R-Normal--*-120-*"

# Make this prominent
set textHighlightColor "Yellow"

set BIG_TEXT_FONT "-*-Helvetica-Bold-R-Normal--*-100-*"
set MEDIUM_TEXT_FONT "-*-Helvetica-Bold-R-Normal--*-80-*"
set SMALL_TEXT_FONT "-*-Helvetica-Medium-R-Normal--*-60-*"
set TINY_TEXT_FONT "-*-Helvetica-Medium-R-Normal--*-40-*"

set BIG_LEADING 14
set MEDIUM_LEADING 10
set SMALL_LEADING 8
set TINY_LEADING 2

set BIG_XOFF 4
set MEDIUM_XOFF 2
set SMALL_XOFF 1
set TINY_XOFF 0

set currentTextFont $BIG_TEXT_FONT
set currentLeading $BIG_LEADING
set currentXoff $BIG_XOFF

# Big old background for the canvas; that is,
# the background color for canvas behind the large processor units
set canvasBoxColor SkyBlue
set mainBackgroundColor $canvasBoxColor

set canvasMemoryColor MidnightBlue

# Colors for the unit cells within each FU
# important color
set canvasSubColor DodgerBlue3

# statistics backgrounds
set statBackground RoyalBlue4
set statForeground "Yellow"

# background color of the display graphs
set GBgColor RoyalBlue4
set GTextColor White
set GLineColor Yellow
set GLabelColor Yellow

# background color of the help window
set HelpFgColor RoyalBlue4
set HelpBgColor White

# background color for the menubar and menu items when active
set activeMenuBackground DodgerBlue3


set StatusMesgColor Orange

# Tool Buttons--that is, the arrows
set activeColor LightSteelBlue
set tbBackgroundColor RoyalBlue4
set tbForegroundColor aquamarine

# whatever
# nobody seems to use or care
set unitBackgroundColor CadetBlue3
set unitForegroundColor CadetBlue1

# you need it, but has no effect?
set canvasBackgroundColor MidnightBlue

# sets the color of the headers
set canvasCoreColor Orange


# for the I/O arrows
set canvasBusColor  DodgerBlue4

# for the acronyms and numbers
set canvasLabelColor Yellow

set arrowColor DodgerBlue3
set backArrowColor DodgerBlue4
set stopArrowColor MidnightBlue

set sbGoColor Yellow
# set sbGoColor1  Green
set sbGoColor1  MidnightBlue
set sbStopColor MidnightBlue

# for the cells of the RUU and LFQ
set Emptycolor $canvasSubColor
set Readycolor Maroon
set Issuedcolor  Orange
# used for RUU/LSQ dispatched
set Dispatchedcolor Gray72
set Completedcolor MidnightBlue
# keep the functional unit busy the same color as the RUU issued color
set FUBusycolor Orange
