# SimpleScalar Visualization Engine
# Help Message Display Functions
#
# *** PUT COPYRIGHT STUFF HERE ***
#=======================================================================#

package require Tk 8.0

#-----------------------------------------------------------------------#
# Help Message options :
#

global StatusMesgColor

proc launchNetscape {HelpPage HelpTopic} {
    global BASE_DIR
    global MYHOME
    set bigmess "Launch the Help Window for SimpleScalar Visualizer?"
    set ans [tk_messageBox \
	    -icon question \
	    -type okcancel \
	    -message "$bigmess" \
	    -parent . \
	    -title "$HelpTopic" ]
    if {[string compare $ans "ok"]} {
	# why does this conditional work the opposite
	# of the way it is supposed to?
	return 0
    }
    #
    # NOTE: The syntax for the EXEC command is very tricky,
    # so please be careful when touching the following line:
    #
    set p0 "netscape"
    set HelpPage "${BASE_DIR}/help/${HelpPage}.htm"
    set WeKnowThatNetscapeIsAlreadyRunning 0

    if {$WeKnowThatNetscapeIsAlreadyRunning} {
	set useOpenNavigator "netscape -remote openFile(${HelpPage})"
	set MainScript [concat "exec" $useOpenNavigator " >/dev/null &"]
    } else {
	set InitScript [concat "exec" "/bin/rm -f ${MYHOME}/.netscape/lock"]
	eval $InitScript
	set MainScript [concat "exec" $p0 $HelpPage " >/dev/null &"]
    }
    # puts "Now do this: $MainScript"
    set newProcessId [eval $MainScript]
}
proc help_message_create {HelpWin} {

    toplevel $HelpWin -class HelpMesg
    label $HelpWin.text
    
    grid $HelpWin.text -column 0 -row 0 -sticky news

    wm overrideredirect $HelpWin 1
    wm withdraw $HelpWin

}

proc display_help_message {win HelpWin} {
  
    global StatusMesgColor

    switch -regexp $win { 

	.stepbar.end { 
	    set StatusMesg "Pause the simulation process"
	    set Mesg "Pause"
	}

	.stepbar.one { 
	    set StatusMesg "Step one cycle"
	    set Mesg "Step one cycle"
	}

	.stepbar.few { 
	    set StatusMesg "Step few cycles (as given by the \
		    collect and display rates)"
	    set Mesg "Step the specified number of cycles"
	}

	.stepbar.all { 
	    set StatusMesg "Step to end of simulation"
	    set Mesg "Step to the end"
	}

	.d1c_thumbnail {

	    set Mesg "DL1 Hit Rate"

	}

	.i1c_thumbnail {

	    set Mesg "IL1 Hit Rate"

	}

	.bpb_thumbnail {

	    set Mesg "Prediction Accuracy"

	}

    }
    
    set bgcolor [option get $HelpWin background {}]
    # set fgcolor [option get $HelpWin foreground {}]
    set fgcolor Black
    $HelpWin.text configure -text $Mesg -fg $fgcolor -bg $bgcolor 
    
    set X [winfo rootx $win]
    set Y [winfo rooty $win]
    set Width [winfo width $win]
    set Height [winfo height $win]
    
    set X [expr $X+$Width/2]
    set Y [expr $Y+$Height+5]

    wm geometry $HelpWin +$X+$Y
    wm deiconify $HelpWin
    raise $HelpWin

    switch -exact $win {

	.i1c_thumbnail -
	.d1c_thumbnail -
	.bpb_thumbnail { }

	default [list status_message .status $StatusMesg $StatusMesgColor]

    }

}
proc remove_help_message {HelpWin} {

    wm withdraw $HelpWin

}
set tFont "-*-Helvetica-Bold-R-Normal--*-100-*"
proc make_help_window {window HelpTopic HelpTitle} {
    global HelpBgColor
    global tFont
    if { [winfo exists .$window] } {
	wm withdraw .$window
        wm deiconify .$window
    } else {
	toplevel .$window -bd 2 -relief groove -width 440 -height 600 \
		-background white
	if {[info exists HelpTitle]} { 
	    set Title $HelpTitle
	} else {
	    set Title $HelpTopic
	}
	wm title .$window $Title
	canvas .${window}.text 
	set tCanvas .${window}.text
    }
    return $tCanvas
}
set curX 10
set curY 10

proc write_one_line {c text} {
    global HelpFgColor
    global curX
    global curY
    # set r [$c create rectangle 0 0 100 100 -fill pink ]
    set t [$c create text $curX $curY -text $text \
	-anchor center -fill black]
    # puts "($curX,$curY, r:$r, t:$t): $text"
    # set listCoords [$c coords $t]
    # puts "coords: $listCoords"
    set curY [expr $curY + 10]
}

proc display_help_text {window HelpTopic HelpTitle} {
    global curY
    set HelpCanvas [make_help_window helptopic $HelpTopic $HelpTitle]
    set help_suffix "hlp"
    global BASE_DIR
    set help_dir ${BASE_DIR}/help
    set help_path ${help_dir}/${HelpTopic}.${help_suffix}
    set f [open "$help_path" "r"]

    set curY 0
    while {! [eof $f]} {
	set line [gets $f]
	write_one_line $HelpCanvas $line
    }
    update idletasks
    update
}

proc display_help_text_save {window HelpTopic HelpTitle} {

	set label "mickey"

	toplevel .${label}_help
	
	# Bind the Enter and Leave mouse events to the corresponding
	# help message display and remove functions.
	
	    canvas .${label}_help.canvas -bd 0 -bg white \
		    -width 480 -height 500 
	    set TCanvas .${label}_help.canvas
	    
	    $TCanvas create rectangle 5 5 100 200 \
		    -outline black -fill white -tags ${label}_thumb_r1
	    
	    $TCanvas create text 5 200 -text "hosdy"
}
